/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.smithwaterman;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.broadinstitute.gatk.utils.exceptions.GATKException;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.smithwaterman.Parameters;
import org.broadinstitute.gatk.utils.smithwaterman.SWParameterSet;
import org.broadinstitute.gatk.utils.smithwaterman.SmithWaterman;

public class SWPairwiseAlignment
implements SmithWaterman {
    protected SWPairwiseAlignmentResult alignmentResult;
    protected final Parameters parameters;
    protected static boolean cutoff = false;
    protected OVERHANG_STRATEGY overhang_strategy = OVERHANG_STRATEGY.SOFTCLIP;
    protected int[][] SW = null;
    protected static boolean keepScoringMatrix = false;

    @Deprecated
    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, int match, int mismatch, int open, int extend) {
        this(seq1, seq2, new Parameters(match, mismatch, open, extend));
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, Parameters parameters) {
        this(parameters);
        this.align(seq1, seq2);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, SWParameterSet parameters, OVERHANG_STRATEGY strategy) {
        this(parameters.parameters);
        this.overhang_strategy = strategy;
        this.align(seq1, seq2);
    }

    protected SWPairwiseAlignment(Parameters parameters) {
        this.parameters = parameters;
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, SWParameterSet namedParameters) {
        this(seq1, seq2, namedParameters.parameters);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2) {
        this(seq1, seq2, SWParameterSet.ORIGINAL_DEFAULT);
    }

    @Override
    public Cigar getCigar() {
        return this.alignmentResult.cigar;
    }

    @Override
    public int getAlignmentStart2wrt1() {
        return this.alignmentResult.alignment_offset;
    }

    protected void align(byte[] reference, byte[] alternate) {
        if (reference == null || reference.length == 0 || alternate == null || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int n = reference.length + 1;
        int m = alternate.length + 1;
        int[][] sw = new int[n][m];
        if (keepScoringMatrix) {
            this.SW = sw;
        }
        int[][] btrack = new int[n][m];
        this.calculateMatrix(reference, alternate, sw, btrack);
        this.alignmentResult = this.calculateCigar(sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, int[][] sw, int[][] btrack) {
        this.calculateMatrix(reference, alternate, sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, int[][] sw, int[][] btrack, OVERHANG_STRATEGY overhang_strategy) {
        if (reference.length == 0 || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int ncol = sw[0].length;
        int nrow = sw.length;
        int MATRIX_MIN_CUTOFF = cutoff ? 0 : -100000000;
        int lowInitValue = -1073741824;
        int[] best_gap_v = new int[ncol + 1];
        Arrays.fill(best_gap_v, lowInitValue);
        int[] gap_size_v = new int[ncol + 1];
        int[] best_gap_h = new int[nrow + 1];
        Arrays.fill(best_gap_h, lowInitValue);
        int[] gap_size_h = new int[nrow + 1];
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL || overhang_strategy == OVERHANG_STRATEGY.LEADING_INDEL) {
            int i;
            int[] topRow = sw[0];
            topRow[1] = this.parameters.w_open;
            int currentValue = this.parameters.w_open;
            for (i = 2; i < topRow.length; ++i) {
                topRow[i] = currentValue += this.parameters.w_extend;
            }
            sw[1][0] = this.parameters.w_open;
            currentValue = this.parameters.w_open;
            for (i = 2; i < sw.length; ++i) {
                sw[i][0] = currentValue += this.parameters.w_extend;
            }
        }
        int[] curRow = sw[0];
        for (int i = 1; i < sw.length; ++i) {
            byte a_base = reference[i - 1];
            int[] lastRow = curRow;
            curRow = sw[i];
            int[] curBackTrackRow = btrack[i];
            for (int j = 1; j < curRow.length; ++j) {
                boolean diagHighestOrEqual;
                byte b_base = alternate[j - 1];
                int step_diag = lastRow[j - 1] + this.wd(a_base, b_base);
                int prev_gap = lastRow[j] + this.parameters.w_open;
                int n = j;
                best_gap_v[n] = best_gap_v[n] + this.parameters.w_extend;
                if (prev_gap > best_gap_v[j]) {
                    best_gap_v[j] = prev_gap;
                    gap_size_v[j] = 1;
                } else {
                    int n2 = j;
                    gap_size_v[n2] = gap_size_v[n2] + 1;
                }
                int step_down = best_gap_v[j];
                int kd = gap_size_v[j];
                prev_gap = curRow[j - 1] + this.parameters.w_open;
                int n3 = i;
                best_gap_h[n3] = best_gap_h[n3] + this.parameters.w_extend;
                if (prev_gap > best_gap_h[i]) {
                    best_gap_h[i] = prev_gap;
                    gap_size_h[i] = 1;
                } else {
                    int n4 = i;
                    gap_size_h[n4] = gap_size_h[n4] + 1;
                }
                int step_right = best_gap_h[i];
                int ki = gap_size_h[i];
                boolean bl = diagHighestOrEqual = step_diag >= step_down && step_diag >= step_right;
                if (diagHighestOrEqual) {
                    curRow[j] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                    curBackTrackRow[j] = 0;
                    continue;
                }
                if (step_right >= step_down) {
                    curRow[j] = Math.max(MATRIX_MIN_CUTOFF, step_right);
                    curBackTrackRow[j] = -ki;
                    continue;
                }
                curRow[j] = Math.max(MATRIX_MIN_CUTOFF, step_down);
                curBackTrackRow[j] = kd;
            }
        }
    }

    protected SWPairwiseAlignmentResult calculateCigar(int[][] sw, int[][] btrack, OVERHANG_STRATEGY overhang_strategy) {
        int alignment_offset;
        int p1 = 0;
        int p2 = 0;
        int refLength = sw.length - 1;
        int altLength = sw[0].length - 1;
        int maxscore = Integer.MIN_VALUE;
        int segment_length = 0;
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL) {
            p1 = refLength;
            p2 = altLength;
        } else {
            p2 = altLength;
            for (int i = 1; i < sw.length; ++i) {
                int curScore = sw[i][altLength];
                if (curScore < maxscore) continue;
                p1 = i;
                maxscore = curScore;
            }
            if (overhang_strategy != OVERHANG_STRATEGY.LEADING_INDEL) {
                int[] bottomRow = sw[refLength];
                for (int j = 1; j < bottomRow.length; ++j) {
                    int curScore = bottomRow[j];
                    if (curScore <= maxscore && (curScore != maxscore || Math.abs(refLength - j) >= Math.abs(p1 - p2))) continue;
                    p1 = refLength;
                    p2 = j;
                    maxscore = curScore;
                    segment_length = altLength - j;
                }
            }
        }
        ArrayList<CigarElement> lce = new ArrayList<CigarElement>(5);
        if (segment_length > 0 && overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(State.CLIP, segment_length));
            segment_length = 0;
        }
        State state = State.MATCH;
        do {
            State new_state;
            int btr = btrack[p1][p2];
            int step_length = 1;
            if (btr > 0) {
                new_state = State.DELETION;
                step_length = btr;
            } else if (btr < 0) {
                new_state = State.INSERTION;
                step_length = -btr;
            } else {
                new_state = State.MATCH;
            }
            switch (new_state) {
                case MATCH: {
                    --p1;
                    --p2;
                    break;
                }
                case INSERTION: {
                    p2 -= step_length;
                    break;
                }
                case DELETION: {
                    p1 -= step_length;
                }
            }
            if (new_state == state) {
                segment_length += step_length;
                continue;
            }
            lce.add(this.makeElement(state, segment_length));
            segment_length = step_length;
            state = new_state;
        } while (p1 > 0 && p2 > 0);
        if (overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(state, segment_length));
            if (p2 > 0) {
                lce.add(this.makeElement(State.CLIP, p2));
            }
            alignment_offset = p1;
        } else if (overhang_strategy == OVERHANG_STRATEGY.IGNORE) {
            lce.add(this.makeElement(state, segment_length + p2));
            alignment_offset = p1 - p2;
        } else {
            lce.add(this.makeElement(state, segment_length));
            if (p1 > 0) {
                lce.add(this.makeElement(State.DELETION, p1));
            } else if (p2 > 0) {
                lce.add(this.makeElement(State.INSERTION, p2));
            }
            alignment_offset = 0;
        }
        Collections.reverse(lce);
        return new SWPairwiseAlignmentResult(AlignmentUtils.consolidateCigar(new Cigar(lce)), alignment_offset);
    }

    protected CigarElement makeElement(State state, int length) {
        CigarOperator op = null;
        switch (state) {
            case MATCH: {
                op = CigarOperator.M;
                break;
            }
            case INSERTION: {
                op = CigarOperator.I;
                break;
            }
            case DELETION: {
                op = CigarOperator.D;
                break;
            }
            case CLIP: {
                op = CigarOperator.S;
            }
        }
        return new CigarElement(length, op);
    }

    private int wd(byte x, byte y) {
        return x == y ? this.parameters.w_match : this.parameters.w_mismatch;
    }

    public void printAlignment(byte[] ref, byte[] read) {
        this.printAlignment(ref, read, 100);
    }

    public void printAlignment(byte[] ref, byte[] read, int width) {
        int j;
        StringBuilder bread = new StringBuilder();
        StringBuilder bref = new StringBuilder();
        StringBuilder match = new StringBuilder();
        int i = 0;
        int offset = this.getAlignmentStart2wrt1();
        Cigar cigar = this.getCigar();
        if (this.overhang_strategy != OVERHANG_STRATEGY.SOFTCLIP && offset < 0) {
            for (j = 0; j < -offset; ++j) {
                bread.append((char)read[j]);
                bref.append(' ');
                match.append(' ');
            }
            ArrayList tweaked = new ArrayList();
            tweaked.addAll(cigar.getCigarElements());
            tweaked.set(0, new CigarElement(cigar.getCigarElement(0).getLength() + offset, cigar.getCigarElement(0).getOperator()));
            cigar = new Cigar(tweaked);
        }
        if (offset > 0) {
            while (i < this.getAlignmentStart2wrt1()) {
                bref.append((char)ref[i]);
                bread.append(' ');
                match.append(' ');
                ++i;
            }
        }
        block8: for (CigarElement e : cigar.getCigarElements()) {
            switch (e.getOperator()) {
                case M: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(i < ref.length ? (char)ref[i] : (char)' ');
                        bread.append(j < read.length ? (char)read[j] : (char)' ');
                        match.append((char)(i < ref.length && j < read.length ? (ref[i] == read[j] ? 46 : 42) : 32));
                        ++z;
                        ++i;
                        ++j;
                    }
                    continue block8;
                }
                case I: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append('-');
                        bread.append((char)read[j]);
                        match.append('I');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case S: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(' ');
                        bread.append((char)read[j]);
                        match.append('S');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case D: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append((char)ref[i]);
                        bread.append('-');
                        match.append('D');
                        ++z;
                        ++i;
                    }
                    continue block8;
                }
                default: {
                    throw new GATKException("Unexpected Cigar element:" + (Object)((Object)e.getOperator()));
                }
            }
        }
        while (i < ref.length) {
            bref.append((char)ref[i]);
            ++i;
        }
        while (j < read.length) {
            bread.append((char)read[j]);
            ++j;
        }
        int maxlength = Math.max(match.length(), Math.max(bread.length(), bref.length()));
        for (int pos = 0; pos < maxlength; pos += width) {
            SWPairwiseAlignment.print_cautiously(match, pos, width);
            SWPairwiseAlignment.print_cautiously(bread, pos, width);
            SWPairwiseAlignment.print_cautiously(bref, pos, width);
            System.out.println();
        }
    }

    private static void print_cautiously(StringBuilder s, int start, int width) {
        if (start >= s.length()) {
            System.out.println();
            return;
        }
        int end = Math.min(start + width, s.length());
        System.out.println(s.substring(start, end));
    }

    protected final class SWPairwiseAlignmentResult {
        public final Cigar cigar;
        public final int alignment_offset;

        public SWPairwiseAlignmentResult(Cigar cigar, int alignment_offset) {
            this.cigar = cigar;
            this.alignment_offset = alignment_offset;
        }
    }

    public static enum OVERHANG_STRATEGY {
        SOFTCLIP,
        INDEL,
        LEADING_INDEL,
        IGNORE;

    }

    protected static enum State {
        MATCH,
        INSERTION,
        DELETION,
        CLIP;

    }
}

