/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import java.io.File;
import org.broadinstitute.gatk.utils.commandline.Tags;

public class SAMReaderID
implements Comparable {
    private final File samFile;
    private final Tags tags;

    public SAMReaderID(File samFile, Tags tags) {
        this.samFile = samFile;
        this.tags = tags;
    }

    public SAMReaderID(String samFileName, Tags tags) {
        this(new File(samFileName), tags);
    }

    public String getSamFilePath() {
        if (this.samFile == null) {
            return null;
        }
        return this.samFile.getAbsolutePath();
    }

    public File getSamFile() {
        return this.samFile;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SAMReaderID)) {
            return false;
        }
        SAMReaderID otherID = (SAMReaderID)other;
        return this.getSamFilePath().equals(otherID.getSamFilePath());
    }

    public int hashCode() {
        return this.samFile.getAbsolutePath().hashCode();
    }

    public String toString() {
        return this.getSamFilePath();
    }

    public int compareTo(Object other) {
        return this.samFile.getAbsolutePath().compareTo(((SAMReaderID)other).samFile.getAbsolutePath());
    }
}

