/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.io.ReferenceBacked;

public class SAMReaderBuilder
implements ReferenceBacked {
    private File samFile = null;
    private File referenceFile = null;
    private ValidationStringency validationStringency = null;

    public void setSAMFile(File samFile) {
        this.samFile = samFile;
    }

    @Override
    public File getReferenceFile() {
        return this.referenceFile;
    }

    @Override
    public void setReferenceFile(File referenceFile) {
        this.referenceFile = referenceFile;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public SamReader build() {
        if (this.samFile == null) {
            throw new ReviewedGATKException("Filename for output sam file must be supplied.");
        }
        if (this.validationStringency == null) {
            throw new ReviewedGATKException("Header for output sam file must be supplied.");
        }
        return SamReaderFactory.makeDefault().referenceSequence(this.getReferenceFile()).validationStringency(this.validationStringency).open(this.samFile);
    }
}

