/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.GATKBin;
import htsjdk.samtools.SAMRecord;
import java.util.Arrays;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ClippedGATKSAMRecord
extends GATKSAMRecord {
    private byte[] insertionQuals;
    private byte[] deletionQuals;

    public ClippedGATKSAMRecord(GATKSAMRecord read, int start, int end) {
        super(read.getHeader());
        this.setReferenceIndex(read.getReferenceIndex());
        this.setAlignmentStart(read.getAlignmentStart() + start);
        this.setMappingQuality(100);
        this.setFlags(read.getFlags());
        this.setMateReferenceIndex(read.getMateReferenceIndex());
        this.setMateAlignmentStart(read.getMateAlignmentStart());
        this.setInferredInsertSize(read.getInferredInsertSize());
        this.setReadBases(Arrays.copyOfRange(read.getReadBases(), start, end));
        this.setBaseQualities(Arrays.copyOfRange(read.getBaseQualities(), start, end));
        this.setReadName(read.getReadName());
        this.insertionQuals = Arrays.copyOfRange(read.getBaseInsertionQualities(), start, end);
        this.deletionQuals = Arrays.copyOfRange(read.getBaseDeletionQualities(), start, end);
        super.setReadName(null);
        super.setCigarString(null);
        super.setReadBases(null);
        super.setBaseQualities(null);
        GATKBin.setReadIndexingBin((SAMRecord)this, (Integer)-1);
    }

    @Override
    public byte[] getBaseDeletionQualities() {
        return this.deletionQuals;
    }

    @Override
    public byte[] getBaseInsertionQualities() {
        return this.insertionQuals;
    }

    @Override
    public int getMappingQuality() {
        return 100;
    }

    @Override
    public int hashCode() {
        return this.getReadName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GATKSAMRecord) {
            return this.getReadName().equals(((GATKSAMRecord)o).getReadName());
        }
        return false;
    }
}

