/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class ArtificialSAMFileReader
implements SamReader,
SamReader.Indexing {
    private SamReader reader;
    private final GenomeLocParser genomeLocParser;
    private final List<SAMRecord> reads;
    private SAMFileHeader customHeader = null;

    public ArtificialSAMFileReader(SAMSequenceDictionary sequenceDictionary, SAMRecord ... reads) {
        SamInputResource samInputResource = SamInputResource.of(ArtificialSAMFileReader.createEmptyInputStream());
        this.reader = SamReaderFactory.makeDefault().open(samInputResource);
        this.genomeLocParser = new GenomeLocParser(sequenceDictionary);
        this.reads = Arrays.asList(reads);
    }

    public ArtificialSAMFileReader(SAMFileHeader customHeader, SAMRecord ... reads) {
        SamInputResource samInputResource = SamInputResource.of(ArtificialSAMFileReader.createEmptyInputStream());
        this.reader = SamReaderFactory.makeDefault().open(samInputResource);
        this.customHeader = customHeader;
        this.genomeLocParser = new GenomeLocParser(customHeader.getSequenceDictionary());
        this.reads = Arrays.asList(reads);
    }

    @Override
    public String getResourceDescription() {
        return this.toString();
    }

    @Override
    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    @Override
    public SamReader.Indexing indexing() {
        return this;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        BAMIndex index = this.getIndex();
        if (!(index instanceof BrowseableBAMIndex)) {
            throw new SAMException("Cannot return index: index created by BAM is not browseable.");
        }
        return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(index);
    }

    @Override
    public boolean hasBrowseableIndex() {
        return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
    }

    @Override
    public BAMIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SAMRecordIterator iterator() {
        return new SAMRecordIterator(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = ArtificialSAMFileReader.this.reads.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void close() {
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }

            @Override
            public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
                return this;
            }
        };
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan chunks) {
        return new SamReader.AssertingIterator(this.reader.iterator());
    }

    @Override
    public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
        GenomeLoc region = this.genomeLocParser.createGenomeLoc(sequence, start, end);
        ArrayList<SAMRecord> coveredSubset = new ArrayList<SAMRecord>();
        for (SAMRecord read : this.reads) {
            GenomeLoc readPosition = this.genomeLocParser.createGenomeLoc(read);
            if (contained && region.containsP(readPosition)) {
                coveredSubset.add(read);
                continue;
            }
            if (contained || !readPosition.overlapsP(region)) continue;
            coveredSubset.add(read);
        }
        final Iterator iterator = coveredSubset.iterator();
        return new SAMRecordIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return (SAMRecord)iterator.next();
            }

            @Override
            public void close() {
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
                return this;
            }
        };
    }

    @Override
    public SAMRecordIterator queryOverlapping(String sequence, int start, int end) {
        return this.query(sequence, start, end, false);
    }

    @Override
    public SAMRecordIterator queryContained(String sequence, int start, int end) {
        return this.query(sequence, start, end, true);
    }

    @Override
    public SAMRecordIterator query(QueryInterval[] intervals, boolean contained) {
        return new SamReader.AssertingIterator(this.reader.query(intervals, contained));
    }

    @Override
    public SAMRecordIterator queryOverlapping(QueryInterval[] intervals) {
        return this.query(intervals, false);
    }

    @Override
    public SAMRecordIterator queryContained(QueryInterval[] intervals) {
        return this.query(intervals, true);
    }

    @Override
    public SAMRecordIterator queryUnmapped() {
        return new SamReader.AssertingIterator(this.reader.queryUnmapped());
    }

    @Override
    public SAMRecordIterator queryAlignmentStart(String sequence, int start) {
        return new SamReader.AssertingIterator(this.reader.queryAlignmentStart(sequence, start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAMRecord queryMate(SAMRecord rec) {
        if (!rec.getReadPairedFlag()) {
            throw new IllegalArgumentException("queryMate called for unpaired read.");
        }
        if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
            throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
        }
        boolean firstOfPair = rec.getFirstOfPairFlag();
        try (SAMRecordIterator it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());){
            SAMRecord next;
            SAMRecord mateRec = null;
            while (it.hasNext()) {
                next = (SAMRecord)it.next();
                if (!next.getReadPairedFlag()) {
                    if (!rec.getReadName().equals(next.getReadName())) continue;
                    throw new SAMFormatException("Paired and unpaired reads with same name: " + rec.getReadName());
                }
                if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                if (mateRec != null) {
                    throw new SAMFormatException("Multiple SAMRecord with read name " + rec.getReadName() + " for " + (firstOfPair ? "second" : "first") + " end.");
                }
                mateRec = next;
            }
            SAMRecord sAMRecord = next = mateRec;
            return sAMRecord;
        }
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return this.reader.indexing().getFilePointerSpanningReads();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    @Override
    public SamReader.Type type() {
        return this.reader.type();
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.customHeader != null ? this.customHeader : this.reader.getFileHeader();
    }

    private static InputStream createEmptyInputStream() {
        try {
            byte[] byteArray = "".getBytes("ISO-8859-1");
            return new ByteArrayInputStream(byteArray);
        }
        catch (Exception ex) {
            throw new ReviewedGATKException("Unable to build empty input stream", ex);
        }
    }
}

