/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.report;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum GATKReportDataType {
    Null("Null"),
    Unknown("Unknown"),
    Boolean("%[Bb]"),
    Character("%[Cc]"),
    Decimal("%.*[EeFf]"),
    Integer("%[Dd]"),
    String("%[Ss]");

    private final String dataTypeString;
    private static final Map<String, GATKReportDataType> lookup;

    private GATKReportDataType(String dataTypeString) {
        this.dataTypeString = dataTypeString;
    }

    public String toString() {
        return this.dataTypeString;
    }

    public static GATKReportDataType fromObject(Object object) {
        GATKReportDataType value = object instanceof Boolean ? Boolean : (object instanceof Character ? Character : (object instanceof Float || object instanceof Double ? Decimal : (object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte ? Integer : (object instanceof String ? String : Unknown))));
        return value;
    }

    public static GATKReportDataType fromFormatString(String format) {
        if (format.equals("")) {
            return Unknown;
        }
        for (GATKReportDataType type : lookup.values()) {
            if (!format.matches(type.toString())) continue;
            return type;
        }
        return Unknown;
    }

    public Object getDefaultValue() {
        switch (this) {
            case Decimal: {
                return 0.0;
            }
            case Boolean: {
                return false;
            }
            case Character: {
                return java.lang.Character.valueOf('0');
            }
            case Integer: {
                return 0L;
            }
            case String: {
                return "";
            }
        }
        return null;
    }

    public boolean isEqual(Object a, Object b) {
        switch (this) {
            case Null: {
                return true;
            }
            case Decimal: 
            case Boolean: 
            case Integer: {
                return a.toString().equals(b.toString());
            }
        }
        return a.equals(b);
    }

    Object Parse(Object obj) {
        if (obj instanceof String) {
            String str = obj.toString();
            switch (this) {
                case Decimal: {
                    return Double.parseDouble(str);
                }
                case Boolean: {
                    return java.lang.Boolean.parseBoolean(str);
                }
                case Integer: {
                    return Long.parseLong(str);
                }
                case String: {
                    return str;
                }
                case Character: {
                    return java.lang.Character.valueOf(str.toCharArray()[0]);
                }
            }
            return str;
        }
        return null;
    }

    public String getDefaultFormatString() {
        switch (this) {
            case Decimal: {
                return "%.8f";
            }
            case Boolean: {
                return "%b";
            }
            case Integer: {
                return "%d";
            }
            case String: {
                return "%s";
            }
            case Character: {
                return "%c";
            }
        }
        return "%s";
    }

    static {
        lookup = new HashMap<String, GATKReportDataType>();
        for (GATKReportDataType s : EnumSet.allOf(GATKReportDataType.class)) {
            lookup.put(s.dataTypeString, s);
        }
    }
}

