/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.utils;

import htsjdk.tribble.Feature;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.HasGenomeLocation;

public abstract class GATKFeature
implements Feature,
HasGenomeLocation {
    String name;

    public GATKFeature(String name) {
        this.name = name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public abstract GenomeLoc getLocation();

    public abstract Object getUnderlyingObject();

    public static class TribbleGATKFeature
    extends GATKFeature {
        private final GenomeLocParser genomeLocParser;
        private final Feature feature;
        private GenomeLoc position = null;

        public TribbleGATKFeature(GenomeLocParser genomeLocParser, Feature f, String name) {
            super(name);
            this.genomeLocParser = genomeLocParser;
            this.feature = f;
        }

        @Override
        public GenomeLoc getLocation() {
            if (this.position == null) {
                this.position = this.genomeLocParser.createGenomeLoc(this.feature.getChr(), this.feature.getStart(), this.feature.getEnd());
            }
            return this.position;
        }

        @Override
        public String getChr() {
            return this.getContig();
        }

        @Override
        public String getContig() {
            return this.feature.getContig();
        }

        @Override
        public int getStart() {
            return this.feature.getStart();
        }

        @Override
        public int getEnd() {
            return this.feature.getEnd();
        }

        @Override
        public Object getUnderlyingObject() {
            return this.feature;
        }
    }
}

