/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import java.util.LinkedList;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.refdata.utils.ComparableList;
import org.broadinstitute.gatk.utils.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.gatk.utils.refdata.utils.RODRecordList;

public class FlashBackIterator
implements LocationAwareSeekableRODIterator {
    private LocationAwareSeekableRODIterator iterator;
    private LinkedList<ComparableList> pastQueue = new LinkedList();
    private LinkedList<ComparableList> aheadQueue = new LinkedList();
    private int MAX_QUEUE = 200;

    public FlashBackIterator(LocationAwareSeekableRODIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public Object getHeader() {
        return this.iterator.getHeader();
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.iterator.getSequenceDictionary();
    }

    @Override
    public GenomeLoc peekNextLocation() {
        return this.aheadQueue.size() > 0 ? this.aheadQueue.getFirst().getLocation() : this.iterator.peekNextLocation();
    }

    @Override
    public GenomeLoc position() {
        return this.aheadQueue.size() > 0 ? this.aheadQueue.getFirst().getLocation() : this.iterator.position();
    }

    @Override
    public RODRecordList seekForward(GenomeLoc interval) {
        RODRecordList lt = this.iterator.seekForward(interval);
        this.createPastRecord(lt);
        return lt;
    }

    @Override
    public boolean hasNext() {
        return this.aheadQueue.size() > 0 || this.iterator.hasNext();
    }

    @Override
    public RODRecordList next() {
        return this.getNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("We don't support remove");
    }

    private RODRecordList getNext() {
        if (this.aheadQueue.size() > 0) {
            RODRecordList ret = this.aheadQueue.getFirst().getList();
            this.aheadQueue.removeFirst();
            return ret;
        }
        RODRecordList ret = (RODRecordList)this.iterator.next();
        this.createPastRecord(ret);
        return ret;
    }

    private void createPastRecord(RODRecordList ret) {
        ComparableList rec = new ComparableList(ret);
        if (rec.getLocation() != null) {
            this.pastQueue.addLast(new ComparableList(ret));
        }
        if (this.pastQueue.size() > this.MAX_QUEUE) {
            this.pastQueue.removeFirst();
        }
    }

    public boolean canFlashBackTo(GenomeLoc location) {
        GenomeLoc farthestBack = this.pastQueue.size() > 0 ? this.pastQueue.getFirst().getLocation() : this.iterator.peekNextLocation();
        return !farthestBack.isPast(location);
    }

    public void flashBackTo(GenomeLoc location) {
        if (!this.canFlashBackTo(location)) {
            throw new UnsupportedOperationException("we can't flash back to " + location);
        }
        if (this.pastQueue.size() == 0) {
            return;
        }
        while (this.pastQueue.size() > 0 && !this.pastQueue.getLast().getLocation().isBefore(location)) {
            this.aheadQueue.addFirst(this.pastQueue.getLast());
            this.pastQueue.removeLast();
        }
    }

    @Override
    public void close() {
        this.aheadQueue.clear();
        this.pastQueue.clear();
    }
}

