/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.utils;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.refdata.utils.GATKFeature;

public class FeatureToGATKFeatureIterator
implements CloseableIterator<GATKFeature> {
    private final GenomeLocParser genomeLocParser;
    private final CloseableTribbleIterator<Feature> iterator;
    private final String name;

    public FeatureToGATKFeatureIterator(GenomeLocParser genomeLocParser, CloseableTribbleIterator<Feature> iter, String name) {
        this.genomeLocParser = genomeLocParser;
        this.name = name;
        this.iterator = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public GATKFeature next() {
        return new GATKFeature.TribbleGATKFeature(this.genomeLocParser, (Feature)this.iterator.next(), this.name);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Why does Iterator have this method? We always throw an exception here");
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

