/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.utils;

import java.util.Comparator;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.HasGenomeLocation;
import org.broadinstitute.gatk.utils.refdata.utils.RODRecordList;

class ComparableList
implements Comparator<ComparableList>,
HasGenomeLocation {
    private RODRecordList list;
    private GenomeLoc location = null;

    public ComparableList(RODRecordList list) {
        this.list = list;
        if (list != null && list.size() != 0) {
            this.location = list.getLocation();
        }
    }

    @Override
    public int compare(ComparableList list1, ComparableList list2) {
        if (list1.location == null && list2.location == null) {
            return 0;
        }
        if (list1.location == null) {
            return 1;
        }
        if (list2.location == null) {
            return -1;
        }
        return list1.location.compareTo(list2.location);
    }

    @Override
    public GenomeLoc getLocation() {
        return this.location;
    }

    public RODRecordList getList() {
        return this.list;
    }
}

