/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.tracks;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.util.LittleEndianOutputStream;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.SequenceDictionaryUtils;
import org.broadinstitute.gatk.utils.ValidationExclusion;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.file.FSLockWithShared;
import org.broadinstitute.gatk.utils.instrumentation.Sizeof;
import org.broadinstitute.gatk.utils.refdata.tracks.FeatureManager;
import org.broadinstitute.gatk.utils.refdata.tracks.IndexDictionaryUtils;
import org.broadinstitute.gatk.utils.refdata.tracks.RMDTrack;
import org.broadinstitute.gatk.utils.refdata.utils.RMDTriplet;

public class RMDTrackBuilder {
    private static final Logger logger = Logger.getLogger(RMDTrackBuilder.class);
    private final SAMSequenceDictionary dict;
    private final GenomeLocParser genomeLocParser;
    private ValidationExclusion.TYPE validationExclusionType;
    private final FeatureManager featureManager;
    private final boolean disableAutoIndexCreation;
    private final Map<String, String> sampleRenameMap;

    public RMDTrackBuilder(SAMSequenceDictionary dict, GenomeLocParser genomeLocParser, ValidationExclusion.TYPE validationExclusionType, boolean disableAutoIndexCreation, Map<String, String> sampleRenameMap) {
        this.dict = dict;
        this.validationExclusionType = validationExclusionType;
        this.genomeLocParser = genomeLocParser;
        this.featureManager = new FeatureManager(ValidationExclusion.lenientVCFProcessing(validationExclusionType));
        this.disableAutoIndexCreation = disableAutoIndexCreation;
        this.sampleRenameMap = sampleRenameMap;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public RMDTrack createInstanceOfTrack(RMDTriplet fileDescriptor) {
        String name = fileDescriptor.getName();
        File inputFile = new File(fileDescriptor.getFile());
        FeatureManager.FeatureDescriptor descriptor = this.getFeatureManager().getByTriplet(fileDescriptor);
        if (descriptor == null) {
            throw new UserException.BadArgumentValue("-B", fileDescriptor.getType());
        }
        Pair<AbstractFeatureReader, SAMSequenceDictionary> pair = ArgumentTypeDescriptor.isCompressed(inputFile.toString()) ? this.createTabixIndexedFeatureSource(descriptor, name, inputFile) : this.getFeatureSource(descriptor, name, inputFile, fileDescriptor.getStorageType());
        if (pair == null) {
            throw new UserException.CouldNotReadInputFile(inputFile, "Unable to make the feature reader for input file");
        }
        this.validateVariantAgainstSequenceDictionary(name, descriptor.getName(), (AbstractFeatureReader)pair.first, (SAMSequenceDictionary)pair.second);
        return new RMDTrack(descriptor.getCodecClass(), name, inputFile, (AbstractFeatureReader)pair.first, (SAMSequenceDictionary)pair.second, this.genomeLocParser, this.createCodec(descriptor, name, inputFile));
    }

    private void validateVariantAgainstSequenceDictionary(String name, String descriptorName, AbstractFeatureReader reader, SAMSequenceDictionary dict) throws UserException {
        List<VCFContigHeaderLine> contigs;
        if (name.equals("variant") && descriptorName.equals("VCF") && reader != null && dict != null && reader.getHeader() != null && (contigs = ((VCFHeader)reader.getHeader()).getContigLines()) != null) {
            ArrayList<SAMSequenceRecord> vcfContigRecords = new ArrayList<SAMSequenceRecord>();
            for (VCFContigHeaderLine contig : contigs) {
                vcfContigRecords.add(contig.getSAMSequenceRecord());
            }
            if (!vcfContigRecords.isEmpty()) {
                SAMSequenceDictionary vcfDictionary = new SAMSequenceDictionary(vcfContigRecords);
                SAMSequenceDictionary sequenceDictionary = new SAMSequenceDictionary(dict.getSequences());
                SequenceDictionaryUtils.validateDictionaries(logger, this.validationExclusionType, name, vcfDictionary, "sequence", sequenceDictionary, false, null, false);
            }
        }
    }

    public RMDTrack createInstanceOfTrack(Class codecClass, File inputFile) {
        FeatureManager.FeatureDescriptor descriptor = this.getFeatureManager().getByCodec(codecClass);
        if (descriptor == null) {
            throw new ReviewedGATKException("Unable to find type name for codec class " + codecClass.getName());
        }
        return this.createInstanceOfTrack(new RMDTriplet("anonymous", descriptor.getName(), inputFile.getAbsolutePath(), RMDTriplet.RMDStorageType.FILE, new Tags()));
    }

    private Pair<AbstractFeatureReader, SAMSequenceDictionary> createTabixIndexedFeatureSource(FeatureManager.FeatureDescriptor descriptor, String name, File inputFile) {
        logger.debug("Attempting to load " + inputFile + " as a tabix indexed file without validating it");
        try {
            return new Pair(AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name, inputFile)), null);
        }
        catch (TribbleException e) {
            throw new UserException(e.getMessage(), e);
        }
    }

    private FeatureCodec createCodec(FeatureManager.FeatureDescriptor descriptor, String name, File inputFile) {
        String remappedSampleName = this.sampleRenameMap != null ? this.sampleRenameMap.get(inputFile.getAbsolutePath()) : null;
        return this.featureManager.createCodec(descriptor, name, this.genomeLocParser, remappedSampleName);
    }

    private Pair<AbstractFeatureReader, SAMSequenceDictionary> getFeatureSource(FeatureManager.FeatureDescriptor descriptor, String name, File inputFile, RMDTriplet.RMDStorageType storageType) {
        boolean canBeIndexed;
        AbstractFeatureReader featureSource = null;
        SAMSequenceDictionary sequenceDictionary = null;
        boolean bl = canBeIndexed = storageType == RMDTriplet.RMDStorageType.FILE;
        if (canBeIndexed) {
            try {
                Index index = this.loadIndex(inputFile, this.createCodec(descriptor, name, inputFile));
                try {
                    logger.info(String.format("  Index for %s has size in bytes %d", inputFile, Sizeof.getObjectGraphSize(index)));
                }
                catch (ReviewedGATKException reviewedGATKException) {
                    // empty catch block
                }
                sequenceDictionary = IndexDictionaryUtils.getSequenceDictionaryFromProperties(index);
                if (sequenceDictionary.isEmpty() && this.dict != null) {
                    this.validateAndUpdateIndexSequenceDictionary(inputFile, index, this.dict);
                    if (!this.disableAutoIndexCreation) {
                        File indexFile = Tribble.indexFile(inputFile);
                        try {
                            this.writeIndexToDisk(index, indexFile, new FSLockWithShared(indexFile));
                        }
                        catch (IOException e) {
                            logger.warn("Unable to update index with the sequence dictionary for file " + indexFile + "; this will not affect your run of the GATK");
                        }
                    }
                    sequenceDictionary = IndexDictionaryUtils.getSequenceDictionaryFromProperties(index);
                }
                featureSource = AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name, inputFile), index);
            }
            catch (TribbleException e) {
                throw new UserException(e.getMessage());
            }
            catch (IOException e) {
                throw new UserException("I/O error loading or writing tribble index file for " + inputFile.getAbsolutePath(), e);
            }
        }
        featureSource = AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name, inputFile), false);
        return new Pair(featureSource, sequenceDictionary);
    }

    public synchronized Index loadIndex(File inputFile, FeatureCodec codec) throws IOException {
        File indexFile = Tribble.indexFile(inputFile);
        FSLockWithShared lock = new FSLockWithShared(indexFile);
        Index idx = null;
        if (indexFile.canRead()) {
            Index index = idx = this.disableAutoIndexCreation ? this.loadFromDisk(inputFile, indexFile) : this.attemptToLockAndLoadIndexFromDisk(inputFile, codec, indexFile, lock);
        }
        if (idx != null) {
            return idx;
        }
        idx = this.createIndexInMemory(inputFile, codec);
        if (!this.disableAutoIndexCreation) {
            this.writeIndexToDisk(idx, indexFile, lock);
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Index attemptToLockAndLoadIndexFromDisk(File inputFile, FeatureCodec codec, File indexFile, FSLockWithShared lock) throws IOException {
        boolean locked = false;
        Index idx = null;
        try {
            locked = lock.sharedLock();
            if (!locked) {
                logger.info(String.format("Could not acquire a shared lock on index file %s, falling back to using an in-memory index for this GATK run.", indexFile.getAbsolutePath()));
                idx = this.createIndexInMemory(inputFile, codec);
            } else {
                idx = this.loadFromDisk(inputFile, indexFile);
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return idx;
    }

    protected Index loadFromDisk(File inputFile, File indexFile) {
        boolean deleted;
        logger.debug("Loading Tribble index from disk for file " + inputFile);
        Index index = IndexFactory.loadIndex(indexFile.getAbsolutePath());
        if (index.isCurrentVersion() && indexFile.lastModified() >= inputFile.lastModified()) {
            return index;
        }
        if (indexFile.lastModified() < inputFile.lastModified()) {
            logger.warn("Index file " + indexFile + " is out of date (index older than input file), " + (this.disableAutoIndexCreation ? "falling back to an in-memory index" : "deleting and updating the index file"));
        } else {
            logger.warn("Index file " + indexFile + " is out of date (old version), " + (this.disableAutoIndexCreation ? "falling back to an in-memory index" : "deleting and updating the index file"));
        }
        if (!this.disableAutoIndexCreation && !(deleted = indexFile.delete())) {
            logger.warn("Index file " + indexFile + " is out of date, but could not be removed; it will not be trusted (we'll try to rebuild an in-memory copy)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndexToDisk(Index index, File indexFile, FSLockWithShared lock) throws IOException {
        if (this.disableAutoIndexCreation) {
            return;
        }
        boolean locked = false;
        try {
            locked = lock.exclusiveLock();
            if (locked) {
                logger.info("Writing Tribble index to disk for file " + indexFile);
                LittleEndianOutputStream stream = new LittleEndianOutputStream(new FileOutputStream(indexFile));
                index.write(stream);
                stream.close();
            } else {
                logger.warn("Unable to write to " + indexFile + " for the index file, creating index in memory only");
            }
            try {
                logger.info(String.format("  Index for %s has size in bytes %d", indexFile, Sizeof.getObjectGraphSize(index)));
            }
            catch (ReviewedGATKException reviewedGATKException) {
                // empty catch block
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    protected Index createIndexInMemory(File inputFile, FeatureCodec codec) {
        logger.debug("Creating Tribble index in memory for file " + inputFile);
        Index idx = IndexFactory.createDynamicIndex(inputFile, codec, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
        this.validateAndUpdateIndexSequenceDictionary(inputFile, idx, this.dict);
        return idx;
    }

    public void validateAndUpdateIndexSequenceDictionary(File inputFile, Index index, SAMSequenceDictionary dict) {
        if (dict == null) {
            throw new ReviewedGATKException("BUG: dict cannot be null");
        }
        SAMSequenceDictionary currentDict = IndexDictionaryUtils.createSequenceDictionaryFromContigList(index, new SAMSequenceDictionary());
        this.validateTrackSequenceDictionary(inputFile.getAbsolutePath(), currentDict, dict);
        IndexDictionaryUtils.setIndexSequenceDictionary(index, dict);
    }

    public void validateTrackSequenceDictionary(String trackName, SAMSequenceDictionary trackDict, SAMSequenceDictionary referenceDict) {
        IndexDictionaryUtils.validateTrackSequenceDictionary(trackName, trackDict, referenceDict, this.validationExclusionType);
    }
}

