/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.tracks;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.gatk.utils.refdata.utils.FeatureToGATKFeatureIterator;
import org.broadinstitute.gatk.utils.refdata.utils.GATKFeature;

public class RMDTrack {
    private static final Logger logger = Logger.getLogger(RMDTrackBuilder.class);
    private final Class type;
    private final String name;
    private final File file;
    private AbstractFeatureReader reader;
    private final SAMSequenceDictionary dictionary;
    private final GenomeLocParser genomeLocParser;
    private final FeatureCodec codec;

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public RMDTrack(Class type, String name, File file, AbstractFeatureReader reader, SAMSequenceDictionary dict, GenomeLocParser genomeLocParser, FeatureCodec codec) {
        this.type = type;
        this.name = name;
        this.file = file;
        this.reader = reader;
        this.dictionary = dict;
        this.genomeLocParser = genomeLocParser;
        this.codec = codec;
    }

    public CloseableIterator<GATKFeature> getIterator() {
        try {
            return new FeatureToGATKFeatureIterator(this.genomeLocParser, this.reader.iterator(), this.getName());
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.getFile(), "Unable to read from file", e);
        }
    }

    public CloseableIterator<GATKFeature> query(GenomeLoc interval) throws IOException {
        CloseableTribbleIterator<Feature> iter = this.reader.query(interval.getContig(), interval.getStart(), interval.getStop());
        return new FeatureToGATKFeatureIterator(this.genomeLocParser, iter, this.getName());
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new UserException.MalformedFile("Unable to close reader " + this.reader.toString(), e);
        }
        this.reader = null;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary;
    }

    public Object getHeader() {
        return this.reader.getHeader();
    }

    public FeatureCodec getCodec() {
        return this.codec;
    }
}

