/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata.tracks;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.MutableIndex;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.SequenceDictionaryUtils;
import org.broadinstitute.gatk.utils.ValidationExclusion;

public class IndexDictionaryUtils {
    private static final Logger logger = Logger.getLogger(IndexDictionaryUtils.class);
    public static final String SequenceDictionaryPropertyPredicate = "DICT:";

    public static SAMSequenceDictionary getSequenceDictionaryFromProperties(Index index) {
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        for (Map.Entry<String, String> entry : index.getProperties().entrySet()) {
            if (!entry.getKey().startsWith(SequenceDictionaryPropertyPredicate)) continue;
            dict.addSequence(new SAMSequenceRecord(entry.getKey().substring(SequenceDictionaryPropertyPredicate.length(), entry.getKey().length()), Integer.valueOf(entry.getValue())));
        }
        return dict;
    }

    static SAMSequenceDictionary createSequenceDictionaryFromContigList(Index index, SAMSequenceDictionary dict) {
        List<String> seqNames = index.getSequenceNames();
        if (seqNames == null) {
            return dict;
        }
        for (String name : seqNames) {
            SAMSequenceRecord seq = new SAMSequenceRecord(name, 0);
            dict.addSequence(seq);
        }
        return dict;
    }

    public static void setIndexSequenceDictionary(Index index, SAMSequenceDictionary dict) {
        for (SAMSequenceRecord seq : dict.getSequences()) {
            String contig = SequenceDictionaryPropertyPredicate + seq.getSequenceName();
            String length = String.valueOf(seq.getSequenceLength());
            ((MutableIndex)index).addProperty(contig, length);
        }
    }

    public static void validateTrackSequenceDictionary(String trackName, SAMSequenceDictionary trackDict, SAMSequenceDictionary referenceDict, ValidationExclusion.TYPE validationExclusionType) {
        if (trackDict == null || trackDict.isEmpty()) {
            logger.warn("Track " + trackName + " doesn't have a sequence dictionary built in, skipping dictionary validation");
        } else {
            TreeSet<String> trackSequences = new TreeSet<String>();
            for (SAMSequenceRecord dictionaryEntry : trackDict.getSequences()) {
                trackSequences.add(dictionaryEntry.getSequenceName());
            }
            SequenceDictionaryUtils.validateDictionaries(logger, validationExclusionType, trackName, trackDict, "reference", referenceDict, false, null, true);
        }
    }
}

