/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata;

import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.classloader.PluginManager;
import org.broadinstitute.gatk.utils.codecs.hapmap.RawHapMapFeature;
import org.broadinstitute.gatk.utils.contexts.ReferenceContext;

public class VariantContextAdaptors {
    private static Map<Class<? extends Feature>, VCAdaptor> adaptors = new HashMap<Class<? extends Feature>, VCAdaptor>();

    public static boolean canBeConvertedToVariantContext(Object variantContainingObject) {
        return adaptors.containsKey(variantContainingObject.getClass());
    }

    public static VariantContext toVariantContext(String name, Object variantContainingObject, ReferenceContext ref) {
        if (!adaptors.containsKey(variantContainingObject.getClass())) {
            return null;
        }
        return adaptors.get(variantContainingObject.getClass()).convert(name, variantContainingObject, ref);
    }

    static {
        PluginManager vcAdaptorManager = new PluginManager(VCAdaptor.class);
        List adaptorInstances = vcAdaptorManager.createAllTypes();
        for (VCAdaptor adaptor : adaptorInstances) {
            adaptors.put(adaptor.getAdaptableFeatureType(), adaptor);
        }
    }

    private static class HapMapAdaptor
    implements VCAdaptor {
        private HapMapAdaptor() {
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return RawHapMapFeature.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            if (ref == null) {
                throw new UnsupportedOperationException("Conversion from HapMap to VariantContext requires a reference context");
            }
            RawHapMapFeature hapmap = (RawHapMapFeature)input;
            int index = hapmap.getStart() - ref.getWindow().getStart();
            if (index < 0) {
                return null;
            }
            HashSet<Allele> alleles = new HashSet<Allele>();
            Allele refSNPAllele = Allele.create(ref.getBase(), true);
            int deletionLength = -1;
            Map<String, Allele> alleleMap = hapmap.getActualAlleles();
            if (alleleMap != null) {
                alleles.addAll(alleleMap.values());
                Allele deletionAllele = alleleMap.get("I");
                if (deletionAllele != null && deletionAllele.isReference()) {
                    deletionLength = deletionAllele.length();
                }
            } else {
                alleles.add(refSNPAllele);
            }
            String[] samples = hapmap.getSampleIDs();
            String[] genotypeStrings = hapmap.getGenotypes();
            GenotypesContext genotypes = GenotypesContext.create(samples.length);
            for (int i = 0; i < samples.length; ++i) {
                if (genotypeStrings[i].contains("N")) continue;
                String a1 = genotypeStrings[i].substring(0, 1);
                String a2 = genotypeStrings[i].substring(1);
                ArrayList<Allele> myAlleles = new ArrayList<Allele>(2);
                if (alleleMap != null) {
                    myAlleles.add(alleleMap.get(a1));
                    myAlleles.add(alleleMap.get(a2));
                } else {
                    if (genotypeStrings[i].contains("I") || genotypeStrings[i].contains("D")) continue;
                    Allele allele1 = Allele.create(a1, refSNPAllele.basesMatch(a1));
                    Allele allele2 = Allele.create(a2, refSNPAllele.basesMatch(a2));
                    myAlleles.add(allele1);
                    myAlleles.add(allele2);
                    alleles.add(allele1);
                    alleles.add(allele2);
                }
                Genotype g = GenotypeBuilder.create(samples[i], myAlleles);
                genotypes.add(g);
            }
            long end = hapmap.getEnd();
            if (deletionLength > 0) {
                end += (long)(deletionLength - 1);
            }
            VariantContext vc = new VariantContextBuilder(name, hapmap.getChr(), hapmap.getStart(), end, alleles).id(hapmap.getName()).genotypes(genotypes).make();
            return vc;
        }
    }

    private static class VariantContextAdaptor
    implements VCAdaptor {
        private VariantContextAdaptor() {
        }

        @Override
        public Class<? extends Feature> getAdaptableFeatureType() {
            return VariantContext.class;
        }

        @Override
        public VariantContext convert(String name, Object input, ReferenceContext ref) {
            return (VariantContext)input;
        }
    }

    public static interface VCAdaptor {
        public Class<? extends Feature> getAdaptableFeatureType();

        public VariantContext convert(String var1, Object var2, ReferenceContext var3);
    }
}

