/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.refdata;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.iterators.PushbackIterator;
import org.broadinstitute.gatk.utils.refdata.RODRecordListImpl;
import org.broadinstitute.gatk.utils.refdata.utils.GATKFeature;
import org.broadinstitute.gatk.utils.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.gatk.utils.refdata.utils.RODRecordList;

public class SeekableRODIterator
implements LocationAwareSeekableRODIterator {
    private final Object header;
    private final GenomeLocParser parser;
    private final SAMSequenceDictionary sequenceDictionary;
    private PushbackIterator<GATKFeature> it;
    List<GATKFeature> records = null;
    String name = null;
    int curr_position = 0;
    int max_position = 0;
    String curr_contig = null;
    boolean next_is_allowed = true;
    int curr_query_end = -1;

    public SeekableRODIterator(Object header, SAMSequenceDictionary rodDictionary, SAMSequenceDictionary referenceDictionary, GenomeLocParser parser, CloseableIterator<GATKFeature> it) {
        this.header = header;
        this.parser = parser;
        this.sequenceDictionary = rodDictionary;
        this.it = new PushbackIterator<GATKFeature>(it);
        this.records = new LinkedList<GATKFeature>();
        GATKFeature r = null;
        if (this.it.hasNext()) {
            r = this.it.element();
        }
        this.name = r == null ? null : r.getName();
        this.curr_contig = referenceDictionary.getSequence(0).getSequenceName();
    }

    @Override
    public Object getHeader() {
        return this.header;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public boolean hasNext() {
        if (this.curr_position < this.max_position) {
            return true;
        }
        return this.it.hasNext();
    }

    @Override
    public GenomeLoc peekNextLocation() {
        if (this.curr_position + 1 <= this.max_position) {
            return this.parser.createGenomeLoc(this.curr_contig, this.curr_position + 1);
        }
        if (this.it.hasNext()) {
            GATKFeature r = this.it.element();
            return this.parser.createGenomeLoc(r.getLocation().getContig(), r.getLocation().getStart());
        }
        return null;
    }

    @Override
    public RODRecordList next() {
        GATKFeature r;
        if (!this.next_is_allowed) {
            throw new ReviewedGATKException("Illegal use of iterator: Can not advance iterator with next() after seek-forward query of length > 1");
        }
        ++this.curr_position;
        if (this.curr_position <= this.max_position) {
            this.purgeOutOfScopeRecords();
        } else {
            this.records.clear();
            r = this.it.next();
            this.records.add(r);
            this.curr_contig = r.getLocation().getContig();
            this.curr_position = r.getLocation().getStart();
            this.max_position = r.getLocation().getStop();
        }
        while (this.it.hasNext()) {
            GenomeLoc thatContig;
            r = this.it.element();
            if (r == null) {
                this.it.next();
                continue;
            }
            GenomeLoc currentContig = this.parser.createOverEntireContig(this.curr_contig);
            if (currentContig.isPast(thatContig = r.getLocation())) {
                throw new UserException("LocationAwareSeekableRODIterator: contig " + r.getLocation().getContig() + " occurs out of order in track " + r.getName());
            }
            if (currentContig.isBefore(thatContig)) break;
            if (r.getLocation().getStart() < this.curr_position) {
                throw new UserException("LocationAwareSeekableRODIterator: track " + r.getName() + " is out of coordinate order on contig " + r.getLocation() + " compared to " + this.curr_contig + ":" + this.curr_position);
            }
            if (r.getLocation().getStart() > this.curr_position) break;
            r = this.it.next();
            int stop = r.getLocation().getStop();
            if (stop < this.curr_position) {
                throw new ReviewedGATKException("DEBUG: encountered contig that should have been loaded earlier");
            }
            if (stop > this.max_position) {
                this.max_position = stop;
            }
            this.records.add(r);
        }
        return new RODRecordListImpl(this.name, this.records, this.parser.createGenomeLoc(this.curr_contig, this.curr_position));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("LocationAwareSeekableRODIterator does not implement remove() operation");
    }

    @Override
    public GenomeLoc position() {
        if (this.curr_contig == null) {
            return null;
        }
        if (this.curr_query_end > this.curr_position) {
            return this.parser.createGenomeLoc(this.curr_contig, this.curr_query_end, this.curr_query_end);
        }
        return this.parser.createGenomeLoc(this.curr_contig, this.curr_position);
    }

    @Override
    public RODRecordList seekForward(GenomeLoc interval) {
        if (interval.isBefore(this.parser.createOverEntireContig(this.curr_contig)) && (interval.getStart() != 0 || interval.getStop() != 0 || !interval.getContig().equals(this.curr_contig))) {
            throw new ReviewedGATKException("Out of order query: query contig " + interval.getContig() + " is located before " + "the iterator's current contig");
        }
        if (interval.getContig().equals(this.curr_contig)) {
            if (interval.getStart() < this.curr_position) {
                throw new ReviewedGATKException("Out of order query: query position " + interval + " is located before " + "the iterator's current position " + this.curr_contig + ":" + this.curr_position);
            }
            if (interval.getStop() < this.curr_query_end) {
                throw new ReviewedGATKException("Unsupported querying sequence: current query interval " + interval + " ends before the end of previous query interval (" + this.curr_query_end + ")");
            }
        }
        this.curr_position = interval.getStart();
        this.curr_query_end = interval.getStop();
        boolean bl = this.next_is_allowed = this.curr_position == this.curr_query_end;
        if (interval.getContig().equals(this.curr_contig) && this.curr_position <= this.max_position) {
            this.purgeOutOfScopeRecords();
        } else {
            this.records.clear();
            this.max_position = -1;
            this.curr_contig = interval.getContig();
        }
        while (this.it.hasNext()) {
            GenomeLoc thatContig;
            GenomeLoc currentContig;
            GATKFeature r = this.it.next();
            if (r == null || (currentContig = this.parser.createOverEntireContig(this.curr_contig)).isPast(thatContig = r.getLocation())) continue;
            if (currentContig.isBefore(thatContig)) {
                this.it.pushback(r);
                break;
            }
            if (r.getLocation().getStop() < this.curr_position) continue;
            if (r.getLocation().getStart() > this.curr_query_end) {
                this.it.pushback(r);
                break;
            }
            if (r.getLocation().getStop() > this.max_position) {
                this.max_position = r.getLocation().getStop();
            }
            this.records.add(r);
        }
        if (this.records.size() > 0) {
            return new RODRecordListImpl(this.name, this.records, interval);
        }
        return null;
    }

    private void purgeOutOfScopeRecords() {
        Iterator<GATKFeature> i = this.records.iterator();
        while (i.hasNext()) {
            GATKFeature r = i.next();
            if (r.getLocation().getStop() >= this.curr_position) continue;
            i.remove();
        }
    }

    @Override
    public void close() {
        if (this.it != null) {
            ((CloseableIterator)this.it.getUnderlyingIterator()).close();
        }
    }
}

