/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.progressmeter;

import java.util.concurrent.TimeUnit;
import org.broadinstitute.gatk.utils.progressmeter.ProgressMeter;

public final class ProgressMeterDaemon
extends Thread {
    private final long secondsBetweenProgressUpdates;
    boolean done = false;
    final ProgressMeter meter;

    public ProgressMeterDaemon(ProgressMeter meter, long secondsBetweenProgressUpdates) {
        if (meter == null) {
            throw new IllegalArgumentException("meter cannot be null");
        }
        if (secondsBetweenProgressUpdates <= 0L) {
            throw new IllegalArgumentException("secondsBetweenProgressUpdates must be greater than 0 but got " + secondsBetweenProgressUpdates);
        }
        this.meter = meter;
        this.secondsBetweenProgressUpdates = secondsBetweenProgressUpdates;
        this.setDaemon(true);
        this.setName("ProgressMeterDaemon");
    }

    public final void done() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        while (!this.done) {
            this.meter.printProgress(false);
            this.meter.updateElapsedTimeInNanoseconds();
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.secondsBetweenProgressUpdates));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

