/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pileup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.gatk.utils.BaseUtils;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.fragments.FragmentCollection;
import org.broadinstitute.gatk.utils.fragments.FragmentUtils;
import org.broadinstitute.gatk.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.gatk.utils.pileup.PerSamplePileupElementTracker;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.pileup.PileupElementFilter;
import org.broadinstitute.gatk.utils.pileup.PileupElementTracker;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileup;
import org.broadinstitute.gatk.utils.pileup.UnifiedPileupElementTracker;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ReadBackedPileupImpl
implements ReadBackedPileup {
    protected final GenomeLoc loc;
    protected final PileupElementTracker<PileupElement> pileupElementTracker;
    private static final int UNINITIALIZED_CACHED_INT_VALUE = -1;
    private int depthOfCoverage = -1;
    private int nDeletions = -1;
    private int nMQ0Reads = -1;

    public ReadBackedPileupImpl(GenomeLoc loc, List<GATKSAMRecord> reads, List<Integer> offsets) {
        this.loc = loc;
        this.pileupElementTracker = this.readsOffsets2Pileup(reads, offsets);
    }

    public ReadBackedPileupImpl(GenomeLoc loc) {
        this(loc, new UnifiedPileupElementTracker<PileupElement>());
    }

    public ReadBackedPileupImpl(GenomeLoc loc, List<PileupElement> pileup) {
        if (loc == null) {
            throw new ReviewedGATKException("Illegal null genomeloc in ReadBackedPileup");
        }
        if (pileup == null) {
            throw new ReviewedGATKException("Illegal null pileup in ReadBackedPileup");
        }
        this.loc = loc;
        this.pileupElementTracker = new UnifiedPileupElementTracker<PileupElement>(pileup);
    }

    @Deprecated
    public ReadBackedPileupImpl(GenomeLoc loc, List<PileupElement> pileup, int size, int nDeletions, int nMQ0Reads) {
        this(loc, pileup);
    }

    protected ReadBackedPileupImpl(GenomeLoc loc, PileupElementTracker<PileupElement> tracker) {
        this.loc = loc;
        this.pileupElementTracker = tracker;
    }

    public ReadBackedPileupImpl(GenomeLoc loc, Map<String, ReadBackedPileupImpl> pileupsBySample) {
        this.loc = loc;
        PerSamplePileupElementTracker<PileupElement> tracker = new PerSamplePileupElementTracker<PileupElement>();
        for (Map.Entry<String, ReadBackedPileupImpl> pileupEntry : pileupsBySample.entrySet()) {
            tracker.addElements(pileupEntry.getKey(), pileupEntry.getValue().pileupElementTracker);
        }
        this.pileupElementTracker = tracker;
    }

    public ReadBackedPileupImpl(GenomeLoc loc, List<GATKSAMRecord> reads, int offset) {
        this.loc = loc;
        this.pileupElementTracker = this.readsOffsets2Pileup(reads, offset);
    }

    private PileupElementTracker<PileupElement> readsOffsets2Pileup(List<GATKSAMRecord> reads, List<Integer> offsets) {
        if (reads == null) {
            throw new ReviewedGATKException("Illegal null read list in UnifiedReadBackedPileup");
        }
        if (offsets == null) {
            throw new ReviewedGATKException("Illegal null offsets list in UnifiedReadBackedPileup");
        }
        if (reads.size() != offsets.size()) {
            throw new ReviewedGATKException("Reads and offset lists have different sizes!");
        }
        UnifiedPileupElementTracker<PileupElement> pileup = new UnifiedPileupElementTracker<PileupElement>();
        for (int i = 0; i < reads.size(); ++i) {
            GATKSAMRecord read = reads.get(i);
            int offset = offsets.get(i);
            pileup.add(this.createNewPileupElement(read, offset));
        }
        return pileup;
    }

    private PileupElementTracker<PileupElement> readsOffsets2Pileup(List<GATKSAMRecord> reads, int offset) {
        if (reads == null) {
            throw new ReviewedGATKException("Illegal null read list in UnifiedReadBackedPileup");
        }
        if (offset < 0) {
            throw new ReviewedGATKException("Illegal offset < 0 UnifiedReadBackedPileup");
        }
        UnifiedPileupElementTracker<PileupElement> pileup = new UnifiedPileupElementTracker<PileupElement>();
        for (GATKSAMRecord read : reads) {
            pileup.add(this.createNewPileupElement(read, offset));
        }
        return pileup;
    }

    protected ReadBackedPileupImpl createNewPileup(GenomeLoc loc, PileupElementTracker<PileupElement> tracker) {
        return new ReadBackedPileupImpl(loc, tracker);
    }

    protected PileupElement createNewPileupElement(GATKSAMRecord read, int offset) {
        return LocusIteratorByState.createPileupForReadAndOffset(read, offset);
    }

    @Override
    public ReadBackedPileupImpl getPileupWithoutDeletions() {
        if (this.getNumberOfDeletions() > 0) {
            if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
                PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
                PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
                for (String sample : tracker.getSamples()) {
                    PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                    ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getPileupWithoutDeletions();
                    filteredTracker.addElements(sample, pileup.pileupElementTracker);
                }
                return this.createNewPileup(this.loc, filteredTracker);
            }
            UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
            UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
            for (PileupElement p : tracker) {
                if (p.isDeletion()) continue;
                filteredTracker.add(p);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        return this;
    }

    @Override
    public ReadBackedPileup getOverlappingFragmentFilteredPileup() {
        return this.getOverlappingFragmentFilteredPileup(true, true);
    }

    @Override
    public ReadBackedPileupImpl getOverlappingFragmentFilteredPileup(boolean discardDiscordant, boolean baseQualNotMapQual) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getOverlappingFragmentFilteredPileup(discardDiscordant, baseQualNotMapQual);
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        HashMap<String, PileupElement> filteredPileup = new HashMap<String, PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            String readName = p.getRead().getReadName();
            if (!filteredPileup.containsKey(readName)) {
                filteredPileup.put(readName, p);
                continue;
            }
            PileupElement existing = (PileupElement)filteredPileup.get(readName);
            if (discardDiscordant && existing.getBase() != p.getBase()) {
                filteredPileup.remove(readName);
                continue;
            }
            if (baseQualNotMapQual) {
                if (existing.getQual() >= p.getQual()) continue;
                filteredPileup.put(readName, p);
                continue;
            }
            if (existing.getMappingQual() >= p.getMappingQual()) continue;
            filteredPileup.put(readName, p);
        }
        UnifiedPileupElementTracker filteredTracker = new UnifiedPileupElementTracker();
        for (PileupElement filteredElement : filteredPileup.values()) {
            filteredTracker.add(filteredElement);
        }
        return this.createNewPileup(this.loc, filteredTracker);
    }

    @Override
    public ReadBackedPileupImpl getPileupWithoutMappingQualityZeroReads() {
        if (this.getNumberOfMappingQualityZeroReads() > 0) {
            if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
                PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
                PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
                for (String sample : tracker.getSamples()) {
                    PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                    ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getPileupWithoutMappingQualityZeroReads();
                    filteredTracker.addElements(sample, pileup.pileupElementTracker);
                }
                return this.createNewPileup(this.loc, filteredTracker);
            }
            UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
            UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
            for (PileupElement p : tracker) {
                if (p.getRead().getMappingQuality() <= 0) continue;
                filteredTracker.add(p);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        return this;
    }

    @Override
    public ReadBackedPileupImpl getPositiveStrandPileup() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getPositiveStrandPileup();
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : tracker) {
            if (p.getRead().getReadNegativeStrandFlag()) continue;
            filteredTracker.add(p);
        }
        return this.createNewPileup(this.loc, filteredTracker);
    }

    @Override
    public ReadBackedPileupImpl getNegativeStrandPileup() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getNegativeStrandPileup();
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : tracker) {
            if (!p.getRead().getReadNegativeStrandFlag()) continue;
            filteredTracker.add(p);
        }
        return this.createNewPileup(this.loc, filteredTracker);
    }

    @Override
    public ReadBackedPileupImpl getFilteredPileup(PileupElementFilter filter) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getFilteredPileup(filter);
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            if (!filter.allow(p)) continue;
            filteredTracker.add(p);
        }
        return this.createNewPileup(this.loc, filteredTracker);
    }

    @Override
    public ReadBackedPileupImpl getBaseAndMappingFilteredPileup(int minBaseQ, int minMapQ) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getBaseAndMappingFilteredPileup(minBaseQ, minMapQ);
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            if (p.getRead().getMappingQuality() < minMapQ || !p.isDeletion() && p.getQual() < minBaseQ) continue;
            filteredTracker.add(p);
        }
        return this.createNewPileup(this.loc, filteredTracker);
    }

    @Override
    public ReadBackedPileup getBaseFilteredPileup(int minBaseQ) {
        return this.getBaseAndMappingFilteredPileup(minBaseQ, -1);
    }

    @Override
    public ReadBackedPileup getMappingFilteredPileup(int minMapQ) {
        return this.getBaseAndMappingFilteredPileup(-1, minMapQ);
    }

    @Override
    public Collection<String> getReadGroups() {
        HashSet<String> readGroups = new HashSet<String>();
        for (PileupElement pileupElement : this) {
            readGroups.add(pileupElement.getRead().getReadGroup().getReadGroupId());
        }
        return readGroups;
    }

    @Override
    public ReadBackedPileupImpl getPileupForReadGroup(String targetReadGroupId) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForReadGroup(targetReadGroupId);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (targetReadGroupId != null) {
                if (read.getReadGroup() == null || !targetReadGroupId.equals(read.getReadGroup().getReadGroupId())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
    }

    @Override
    public ReadBackedPileupImpl getPileupForReadGroups(HashSet<String> rgSet) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForReadGroups((HashSet)rgSet);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, ((ReadBackedPileupImpl)pileup).pileupElementTracker);
            }
            return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (rgSet != null && !rgSet.isEmpty()) {
                if (read.getReadGroup() == null || !rgSet.contains(read.getReadGroup().getReadGroupId())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
    }

    @Override
    public ReadBackedPileupImpl getPileupForLane(String laneID) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker<PileupElement> perSampleElements = tracker.getElements(sample);
                ReadBackedPileupImpl pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForLane(laneID);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, pileup.pileupElementTracker);
            }
            return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (laneID != null) {
                if ((read.getReadGroup() == null || !read.getReadGroup().getReadGroupId().startsWith(laneID + ".")) && !read.getReadGroup().getReadGroupId().equals(laneID)) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
    }

    @Override
    public Collection<String> getSamples() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            return new HashSet<String>(tracker.getSamples());
        }
        HashSet<String> sampleNames = new HashSet<String>();
        for (PileupElement p : this) {
            GATKSAMRecord read = p.getRead();
            String sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
            sampleNames.add(sampleName);
        }
        return sampleNames;
    }

    @Override
    public ReadBackedPileup getDownsampledPileup(int desiredCoverage) {
        if (this.getNumberOfElements() <= desiredCoverage) {
            return this;
        }
        TreeSet<Integer> positions = new TreeSet<Integer>();
        int i = 0;
        while (i < desiredCoverage) {
            if (!positions.add(Utils.getRandomGenerator().nextInt(this.getNumberOfElements()))) continue;
            ++i;
        }
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PileupElement> filteredTracker = new PerSamplePileupElementTracker<PileupElement>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                int current = 0;
                UnifiedPileupElementTracker<PileupElement> filteredPileup = new UnifiedPileupElementTracker<PileupElement>();
                for (PileupElement p : perSampleElements) {
                    if (positions.contains(current)) {
                        filteredPileup.add(p);
                    }
                    ++current;
                }
                filteredTracker.addElements(sample, filteredPileup);
            }
            return this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        Iterator positionIter = positions.iterator();
        while (positionIter.hasNext()) {
            int nextReadToKeep = (Integer)positionIter.next();
            filteredTracker.add((PileupElement)tracker.get(nextReadToKeep));
        }
        return this.createNewPileup(this.getLocation(), filteredTracker);
    }

    @Override
    public ReadBackedPileup getPileupForSamples(Collection<String> sampleNames) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PileupElementTracker<PileupElement> filteredElements = tracker.getElements(sampleNames);
            return filteredElements != null ? this.createNewPileup(this.loc, filteredElements) : null;
        }
        HashSet<String> hashSampleNames = new HashSet<String>(sampleNames);
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (sampleNames != null) {
                if (read.getReadGroup() == null || !hashSampleNames.contains(read.getReadGroup().getSample())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getSample() != null) continue;
            filteredTracker.add(p);
        }
        return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
    }

    @Override
    public Map<String, ReadBackedPileup> getPileupsForSamples(Collection<String> sampleNames) {
        HashMap<String, ReadBackedPileup> result = new HashMap<String, ReadBackedPileup>();
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            for (String string : sampleNames) {
                PileupElementTracker<PileupElement> filteredElements = tracker.getElements(string);
                if (filteredElements == null) continue;
                result.put(string, this.createNewPileup(this.loc, filteredElements));
            }
        } else {
            HashMap trackerMap = new HashMap();
            for (String string : sampleNames) {
                UnifiedPileupElementTracker filteredTracker = new UnifiedPileupElementTracker();
                trackerMap.put(string, filteredTracker);
            }
            for (PileupElement pileupElement : this.pileupElementTracker) {
                String sample;
                UnifiedPileupElementTracker tracker;
                GATKSAMRecord read = pileupElement.getRead();
                if (read.getReadGroup() == null || (tracker = (UnifiedPileupElementTracker)trackerMap.get(sample = read.getReadGroup().getSample())) == null) continue;
                tracker.add(pileupElement);
            }
            for (Map.Entry entry : trackerMap.entrySet()) {
                result.put((String)entry.getKey(), this.createNewPileup(this.loc, (PileupElementTracker)entry.getValue()));
            }
        }
        return result;
    }

    @Override
    public ReadBackedPileup getPileupForSample(String sampleName) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PileupElementTracker<PileupElement> filteredElements = tracker.getElements(sampleName);
            return filteredElements != null ? this.createNewPileup(this.loc, filteredElements) : null;
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (sampleName != null) {
                if (read.getReadGroup() == null || !sampleName.equals(read.getReadGroup().getSample())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getSample() != null) continue;
            filteredTracker.add(p);
        }
        return filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null;
    }

    @Override
    public Iterator<PileupElement> iterator() {
        return new Iterator<PileupElement>(){
            private final Iterator<PileupElement> wrappedIterator;
            {
                this.wrappedIterator = ReadBackedPileupImpl.this.pileupElementTracker.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrappedIterator.hasNext();
            }

            @Override
            public PileupElement next() {
                return this.wrappedIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from a pileup element iterator");
            }
        };
    }

    @Override
    public int getNumberOfDeletions() {
        if (this.nDeletions == -1) {
            this.nDeletions = 0;
            for (PileupElement p : this.pileupElementTracker.unorderedIterable()) {
                if (!p.isDeletion()) continue;
                ++this.nDeletions;
            }
        }
        return this.nDeletions;
    }

    @Override
    public int getNumberOfMappingQualityZeroReads() {
        if (this.nMQ0Reads == -1) {
            this.nMQ0Reads = 0;
            for (PileupElement p : this.pileupElementTracker.unorderedIterable()) {
                if (p.getRead().getMappingQuality() != 0) continue;
                ++this.nMQ0Reads;
            }
        }
        return this.nMQ0Reads;
    }

    @Override
    public int getNumberOfElements() {
        return this.pileupElementTracker.size();
    }

    @Override
    public int depthOfCoverage() {
        if (this.depthOfCoverage == -1) {
            this.depthOfCoverage = this.pileupElementTracker.size();
        }
        return this.depthOfCoverage;
    }

    @Override
    public boolean isEmpty() {
        return this.getNumberOfElements() == 0;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.loc;
    }

    @Override
    public int[] getBaseCounts() {
        int[] counts = new int[4];
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            for (String sample : tracker.getSamples()) {
                int[] countsBySample = this.createNewPileup(this.loc, tracker.getElements(sample)).getBaseCounts();
                for (int i = 0; i < counts.length; ++i) {
                    int n = i;
                    counts[n] = counts[n] + countsBySample[i];
                }
            }
        } else {
            for (PileupElement pile : this) {
                int index;
                if (pile.isDeletion() || (index = BaseUtils.simpleBaseToBaseIndex((char)pile.getBase())) == -1) continue;
                int n = index;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    @Override
    public String getPileupString(Character ref) {
        return String.format("%s %s %c %s %s", this.getLocation().getContig(), this.getLocation().getStart(), ref, new String(this.getBases()), this.getQualsString());
    }

    @Override
    public List<GATKSAMRecord> getReads() {
        ArrayList<GATKSAMRecord> reads = new ArrayList<GATKSAMRecord>(this.getNumberOfElements());
        for (PileupElement pile : this) {
            reads.add(pile.getRead());
        }
        return reads;
    }

    @Override
    public int getNumberOfDeletionsAfterThisElement() {
        int count = 0;
        for (PileupElement p : this.pileupElementTracker.unorderedIterable()) {
            if (!p.isBeforeDeletionStart()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getNumberOfInsertionsAfterThisElement() {
        int count = 0;
        for (PileupElement p : this.pileupElementTracker.unorderedIterable()) {
            if (!p.isBeforeInsertion()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<Integer> getOffsets() {
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.getNumberOfElements());
        for (PileupElement pile : this.pileupElementTracker.unorderedIterable()) {
            offsets.add(pile.getOffset());
        }
        return offsets;
    }

    @Override
    public byte[] getBases() {
        byte[] v = new byte[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = pile.getBase();
        }
        return v;
    }

    @Override
    public byte[] getQuals() {
        byte[] v = new byte[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = pile.getQual();
        }
        return v;
    }

    @Override
    public int[] getMappingQuals() {
        int[] v = new int[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = pile.getRead().getMappingQuality();
        }
        return v;
    }

    static String quals2String(byte[] quals) {
        StringBuilder qualStr = new StringBuilder();
        for (int n : quals) {
            n = Math.min(n, 63);
            char qualChar = (char)(33 + n);
            qualStr.append(qualChar);
        }
        return qualStr.toString();
    }

    private String getQualsString() {
        return ReadBackedPileupImpl.quals2String(this.getQuals());
    }

    @Override
    public ReadBackedPileup getStartSortedPileup() {
        PileupElementTracker tracker;
        TreeSet<PileupElement> sortedElements = new TreeSet<PileupElement>(new Comparator<PileupElement>(){

            @Override
            public int compare(PileupElement element1, PileupElement element2) {
                int difference = element1.getRead().getAlignmentStart() - element2.getRead().getAlignmentStart();
                return difference != 0 ? difference : element1.getRead().getReadName().compareTo(element2.getRead().getReadName());
            }
        });
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            for (String sample : ((PerSamplePileupElementTracker)tracker).getSamples()) {
                PileupElementTracker perSampleElements = ((PerSamplePileupElementTracker)tracker).getElements(sample);
                for (PileupElement pile : perSampleElements) {
                    sortedElements.add(pile);
                }
            }
        } else {
            tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
            for (PileupElement pile : tracker) {
                sortedElements.add(pile);
            }
        }
        UnifiedPileupElementTracker<PileupElement> sortedTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement pile : sortedElements) {
            sortedTracker.add(pile);
        }
        return this.createNewPileup(this.loc, sortedTracker);
    }

    @Override
    public FragmentCollection<PileupElement> toFragments() {
        return FragmentUtils.create(this);
    }

    @Override
    public ReadBackedPileup copy() {
        return new ReadBackedPileupImpl(this.loc, this.pileupElementTracker.copy());
    }
}

