/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.intel.gkl.pairhmm.IntelPairHmm;
import com.intel.gkl.pairhmm.IntelPairHmmFpga;
import com.intel.gkl.pairhmm.IntelPairHmmOMP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.pairhmm.HaplotypeDataHolder;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeArguments;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeBinding;
import org.broadinstitute.gatk.nativebindings.pairhmm.ReadDataHolder;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.genotyper.ReadLikelihoods;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.pairhmm.JNILoglessPairHMM;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class VectorLoglessPairHMM
extends JNILoglessPairHMM {
    protected static final Logger logger = Logger.getLogger(VectorLoglessPairHMM.class);
    private final PairHMMNativeBinding pairHmm;
    private HashMap<Haplotype, Integer> haplotypeToHaplotypeListIdxMap = new HashMap();
    private HaplotypeDataHolder[] mHaplotypeDataArray;

    public VectorLoglessPairHMM(Implementation implementation, PairHMMNativeArguments args) throws UserException.HardwareFeatureException {
        switch (implementation) {
            case AVX: {
                this.pairHmm = new IntelPairHmm();
                boolean isSupported = this.pairHmm.load(null);
                if (!isSupported) {
                    throw new UserException.HardwareFeatureException("Machine does not support AVX PairHMM.");
                }
                logger.info("Using AVX-accelerated native PairHMM implementation");
                break;
            }
            case OMP: {
                this.pairHmm = new IntelPairHmmOMP();
                boolean isSupported = this.pairHmm.load(null);
                if (!isSupported) {
                    throw new UserException.HardwareFeatureException("Machine does not support OpenMP AVX PairHMM.");
                }
                logger.info("Using OpenMP multi-threaded AVX-accelerated native PairHMM implementation");
                break;
            }
            case FPGA: {
                this.pairHmm = new IntelPairHmmFpga();
                boolean isSupported = this.pairHmm.load(null);
                if (!isSupported) {
                    throw new UserException.HardwareFeatureException("Machine does not support FPGA PairHMM.");
                }
                logger.info("Using FPGA-accelerated native PairHMM implementation");
                break;
            }
            default: {
                throw new UserException.HardwareFeatureException("Unknown PairHMM implementation.");
            }
        }
        this.pairHmm.initialize(args);
    }

    @Override
    public HashMap<Haplotype, Integer> getHaplotypeToHaplotypeListIdxMap() {
        return this.haplotypeToHaplotypeListIdxMap;
    }

    @Override
    public void initialize(List<Haplotype> haplotypes, Map<String, List<GATKSAMRecord>> perSampleReadList, int readMaxLength, int haplotypeMaxLength) {
        int numHaplotypes = haplotypes.size();
        this.mHaplotypeDataArray = new HaplotypeDataHolder[numHaplotypes];
        int idx = 0;
        this.haplotypeToHaplotypeListIdxMap.clear();
        for (Haplotype currHaplotype : haplotypes) {
            this.mHaplotypeDataArray[idx] = new HaplotypeDataHolder();
            this.mHaplotypeDataArray[idx].haplotypeBases = currHaplotype.getBases();
            this.haplotypeToHaplotypeListIdxMap.put(currHaplotype, idx);
            ++idx;
        }
    }

    @Override
    public void computeLikelihoods(ReadLikelihoods.Matrix<Haplotype> likelihoods, List<GATKSAMRecord> processedReads, Map<GATKSAMRecord, byte[]> gcp) {
        if (processedReads.isEmpty()) {
            return;
        }
        if (doProfiling.booleanValue()) {
            this.startTime = System.nanoTime();
        }
        int readListSize = processedReads.size();
        int numHaplotypes = likelihoods.alleleCount();
        ReadDataHolder[] readDataArray = new ReadDataHolder[readListSize];
        int idx = 0;
        for (GATKSAMRecord read : processedReads) {
            readDataArray[idx] = new ReadDataHolder();
            readDataArray[idx].readBases = read.getReadBases();
            readDataArray[idx].readQuals = read.getBaseQualities();
            readDataArray[idx].insertionGOP = read.getBaseInsertionQualities();
            readDataArray[idx].deletionGOP = read.getBaseDeletionQualities();
            readDataArray[idx].overallGCP = gcp.get(read);
            ++idx;
        }
        this.mLikelihoodArray = new double[readListSize * numHaplotypes];
        if (doProfiling.booleanValue()) {
            this.threadLocalSetupTimeDiff = System.nanoTime() - this.startTime;
        }
        this.pairHmm.computeLikelihoods(readDataArray, this.mHaplotypeDataArray, this.mLikelihoodArray);
        int readIdx = 0;
        for (int r = 0; r < readListSize; ++r) {
            int hapIdx = 0;
            for (Haplotype haplotype : likelihoods.alleles()) {
                int idxInsideHaplotypeList = this.haplotypeToHaplotypeListIdxMap.get(haplotype);
                likelihoods.set(hapIdx, r, this.mLikelihoodArray[readIdx + idxInsideHaplotypeList]);
                ++hapIdx;
            }
            readIdx += numHaplotypes;
        }
        if (doProfiling.booleanValue()) {
            this.threadLocalPairHMMComputeTimeDiff = System.nanoTime() - this.startTime;
            pairHMMComputeTime += this.threadLocalPairHMMComputeTimeDiff;
            pairHMMSetupTime += this.threadLocalSetupTimeDiff;
        }
    }

    @Override
    public void close() {
        this.pairHmm.done();
        if (doProfiling.booleanValue()) {
            logger.info("Time spent in setup for JNI call : " + (double)pairHMMSetupTime * 1.0E-9);
        }
        super.close();
    }

    public static enum Implementation {
        AVX,
        OMP,
        FPGA;

    }
}

