/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Requires;
import htsjdk.variant.variantcontext.Allele;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.genotyper.ReadLikelihoods;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public abstract class PairHMM {
    protected static final Logger logger = Logger.getLogger(PairHMM.class);
    protected boolean constantsAreInitialized = false;
    protected byte[] previousHaplotypeBases;
    protected int hapStartIndex;
    public static final byte BASE_QUALITY_SCORE_THRESHOLD = 18;
    protected int maxHaplotypeLength;
    protected int maxReadLength;
    protected int paddedMaxReadLength;
    protected int paddedMaxHaplotypeLength;
    protected int paddedReadLength;
    protected int paddedHaplotypeLength;
    protected boolean initialized = false;
    protected boolean doNotUseTristateCorrection = false;
    protected double[] mLikelihoodArray;
    protected static Boolean doProfiling = true;
    protected static long pairHMMComputeTime = 0L;
    protected long threadLocalPairHMMComputeTimeDiff = 0L;
    protected long startTime = 0L;

    protected void doNotUseTristateCorrection() {
        this.doNotUseTristateCorrection = true;
    }

    public void initialize(int readMaxLength, int haplotypeMaxLength) throws IllegalArgumentException {
        if (readMaxLength <= 0) {
            throw new IllegalArgumentException("READ_MAX_LENGTH must be > 0 but got " + readMaxLength);
        }
        if (haplotypeMaxLength <= 0) {
            throw new IllegalArgumentException("HAPLOTYPE_MAX_LENGTH must be > 0 but got " + haplotypeMaxLength);
        }
        this.maxHaplotypeLength = haplotypeMaxLength;
        this.maxReadLength = readMaxLength;
        this.paddedMaxReadLength = readMaxLength + 1;
        this.paddedMaxHaplotypeLength = haplotypeMaxLength + 1;
        this.previousHaplotypeBases = null;
        this.constantsAreInitialized = false;
        this.initialized = true;
    }

    public void finalizeRegion() {
    }

    public void initialize(List<Haplotype> haplotypes, Map<String, List<GATKSAMRecord>> perSampleReadList, int readMaxLength, int haplotypeMaxLength) {
        this.initialize(readMaxLength, haplotypeMaxLength);
    }

    private int findMaxReadLength(GATKSAMRecord ... reads) {
        int max = 0;
        for (GATKSAMRecord read : reads) {
            int readLength = read.getReadLength();
            if (max >= readLength) continue;
            max = readLength;
        }
        return max;
    }

    private int findMaxAlleleLength(List<? extends Allele> alleles) {
        int max = 0;
        for (Allele allele : alleles) {
            int alleleLength = allele.length();
            if (max >= alleleLength) continue;
            max = alleleLength;
        }
        return max;
    }

    protected int findMaxReadLength(List<GATKSAMRecord> reads) {
        int listMaxReadLength = 0;
        for (GATKSAMRecord read : reads) {
            int readLength = read.getReadLength();
            if (readLength <= listMaxReadLength) continue;
            listMaxReadLength = readLength;
        }
        return listMaxReadLength;
    }

    protected int findMaxHaplotypeLength(Collection<Haplotype> haplotypes) {
        int listMaxHaplotypeLength = 0;
        for (Haplotype h : haplotypes) {
            int haplotypeLength = h.getBases().length;
            if (haplotypeLength <= listMaxHaplotypeLength) continue;
            listMaxHaplotypeLength = haplotypeLength;
        }
        return listMaxHaplotypeLength;
    }

    public void computeLikelihoods(ReadLikelihoods.Matrix<Haplotype> likelihoods, List<GATKSAMRecord> processedReads, Map<GATKSAMRecord, byte[]> gcp) {
        if (processedReads.isEmpty()) {
            return;
        }
        if (doProfiling.booleanValue()) {
            this.startTime = System.nanoTime();
        }
        int readMaxLength = this.findMaxReadLength(processedReads);
        int haplotypeMaxLength = this.findMaxAlleleLength(likelihoods.alleles());
        if (!this.initialized || readMaxLength > this.maxReadLength || haplotypeMaxLength > this.maxHaplotypeLength) {
            this.initialize(readMaxLength, haplotypeMaxLength);
        }
        int readCount = processedReads.size();
        List<Haplotype> alleles = likelihoods.alleles();
        int alleleCount = alleles.size();
        this.mLikelihoodArray = new double[readCount * alleleCount];
        int idx = 0;
        int readIndex = 0;
        for (GATKSAMRecord read : processedReads) {
            byte[] readBases = read.getReadBases();
            byte[] readQuals = read.getBaseQualities();
            byte[] readInsQuals = read.getBaseInsertionQualities();
            byte[] readDelQuals = read.getBaseDeletionQualities();
            byte[] overallGCP = gcp.get(read);
            boolean isFirstHaplotype = true;
            for (int a = 0; a < alleleCount; ++a) {
                Allele allele = alleles.get(a);
                byte[] alleleBases = allele.getBases();
                byte[] nextAlleleBases = a == alleles.size() - 1 ? null : alleles.get(a + 1).getBases();
                double lk = this.computeReadLikelihoodGivenHaplotypeLog10(alleleBases, readBases, readQuals, readInsQuals, readDelQuals, overallGCP, true, nextAlleleBases);
                likelihoods.set(a, readIndex, lk);
                this.mLikelihoodArray[idx++] = lk;
            }
            ++readIndex;
        }
        if (doProfiling.booleanValue()) {
            this.threadLocalPairHMMComputeTimeDiff = System.nanoTime() - this.startTime;
            pairHMMComputeTime += this.threadLocalPairHMMComputeTimeDiff;
        }
    }

    protected final double computeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, boolean recacheReadValues, byte[] nextHaploytpeBases) throws IllegalStateException, IllegalArgumentException {
        if (!this.initialized) {
            throw new IllegalStateException("Must call initialize before calling computeReadLikelihoodGivenHaplotypeLog10");
        }
        if (haplotypeBases == null) {
            throw new IllegalArgumentException("haplotypeBases cannot be null");
        }
        if (haplotypeBases.length > this.maxHaplotypeLength) {
            throw new IllegalArgumentException("Haplotype bases is too long, got " + haplotypeBases.length + " but max is " + this.maxHaplotypeLength);
        }
        if (readBases == null) {
            throw new IllegalArgumentException("readBases cannot be null");
        }
        if (readBases.length > this.maxReadLength) {
            throw new IllegalArgumentException("readBases is too long, got " + readBases.length + " but max is " + this.maxReadLength);
        }
        if (readQuals.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read quals aren't the same size: " + readBases.length + " vs " + readQuals.length);
        }
        if (insertionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read insertion quals aren't the same size: " + readBases.length + " vs " + insertionGOP.length);
        }
        if (deletionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read deletion quals aren't the same size: " + readBases.length + " vs " + deletionGOP.length);
        }
        if (overallGCP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and overall GCP aren't the same size: " + readBases.length + " vs " + overallGCP.length);
        }
        this.paddedReadLength = readBases.length + 1;
        this.paddedHaplotypeLength = haplotypeBases.length + 1;
        this.hapStartIndex = recacheReadValues ? 0 : this.hapStartIndex;
        int nextHapStartIndex = nextHaploytpeBases == null || haplotypeBases.length != nextHaploytpeBases.length ? 0 : PairHMM.findFirstPositionWhereHaplotypesDiffer(haplotypeBases, nextHaploytpeBases);
        double result = this.subComputeReadLikelihoodGivenHaplotypeLog10(haplotypeBases, readBases, readQuals, insertionGOP, deletionGOP, overallGCP, this.hapStartIndex, recacheReadValues, nextHapStartIndex);
        if (result > 0.0) {
            throw new IllegalStateException("PairHMM Log Probability cannot be greater than 0: " + String.format("haplotype: %s, read: %s, result: %f, PairHMM: %s", new String(haplotypeBases), new String(readBases), result, this.getClass().getSimpleName()));
        }
        if (!MathUtils.goodLog10Probability(result)) {
            throw new IllegalStateException("Invalid Log Probability: " + result);
        }
        this.previousHaplotypeBases = haplotypeBases;
        this.hapStartIndex = nextHapStartIndex < this.hapStartIndex ? 0 : nextHapStartIndex;
        return result;
    }

    @Requires(value={"readBases.length == readQuals.length", "readBases.length == insertionGOP.length", "readBases.length == deletionGOP.length", "readBases.length == overallGCP.length", "matchMatrix!=null", "insertionMatrix!=null", "deletionMatrix!=null"})
    protected abstract double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7, boolean var8, int var9);

    public static int findFirstPositionWhereHaplotypesDiffer(byte[] haplotype1, byte[] haplotype2) throws IllegalArgumentException {
        if (haplotype1 == null || haplotype1.length == 0) {
            throw new IllegalArgumentException("Haplotype1 is bad " + Arrays.toString(haplotype1));
        }
        if (haplotype2 == null || haplotype2.length == 0) {
            throw new IllegalArgumentException("Haplotype2 is bad " + Arrays.toString(haplotype2));
        }
        for (int iii = 0; iii < haplotype1.length && iii < haplotype2.length; ++iii) {
            if (haplotype1[iii] == haplotype2[iii]) continue;
            return iii;
        }
        return Math.min(haplotype1.length, haplotype2.length);
    }

    public static void setNumberOfThreads(int numThreads) {
        doProfiling = numThreads == 1;
        if (numThreads > 1) {
            logger.info("Performance profiling for PairHMM is disabled because the program is being run with multiple threads (-nct>1) option\nProfiling is enabled only when running in single thread mode\n");
        }
    }

    public double[] getLikelihoodArray() {
        return this.mLikelihoodArray;
    }

    public void close() {
        if (doProfiling.booleanValue()) {
            logger.info("Total compute time in PairHMM computeLikelihoods() : " + (double)pairHMMComputeTime * 1.0E-9);
        }
    }

    public static enum HMM_IMPLEMENTATION {
        EXACT,
        ORIGINAL,
        LOGLESS_CACHING,
        VECTOR_LOGLESS_CACHING,
        VECTOR_LOGLESS_CACHING_OMP,
        VECTOR_LOGLESS_CACHING_FPGA_EXPERIMENTAL,
        FASTEST_AVAILABLE,
        DEBUG_VECTOR_LOGLESS_CACHING,
        ARRAY_LOGLESS;

    }
}

