/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.locusiterator;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.SimpleTimer;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;
import org.broadinstitute.gatk.utils.commandline.Input;
import org.broadinstitute.gatk.utils.contexts.AlignmentContext;
import org.broadinstitute.gatk.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.gatk.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.gatk.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecordIterator;

public class LIBSPerformance
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(LIBSPerformance.class);
    @Input(fullName="input_file", shortName="I", doc="SAM or BAM file(s)", required=true)
    public File samFile = null;
    @Input(fullName="reference_sequence", shortName="R", doc="Reference sequence file", required=true)
    public File referenceFile = null;
    @Argument(fullName="L", shortName="L", doc="Query location", required=false)
    public String location = null;
    @Argument(fullName="dt", shortName="dt", doc="Enable downsampling", required=false)
    public boolean downsample = false;

    @Override
    public int execute() throws IOException {
        SAMRecordIterator rawIterator;
        CachingIndexedFastaSequenceFile reference = new CachingIndexedFastaSequenceFile(this.referenceFile);
        GenomeLocParser genomeLocParser = new GenomeLocParser(reference);
        SamReader reader = SamReaderFactory.makeDefault().open(this.samFile);
        if (this.location == null) {
            rawIterator = reader.iterator();
        } else {
            GenomeLoc loc = genomeLocParser.parseGenomeLoc(this.location);
            rawIterator = reader.query(loc.getContig(), loc.getStart(), loc.getStop(), false);
        }
        GATKSAMRecordIterator iterator = new GATKSAMRecordIterator(rawIterator);
        HashSet<String> samples = new HashSet<String>();
        for (SAMReadGroupRecord rg : reader.getFileHeader().getReadGroups()) {
            samples.add(rg.getSample());
        }
        reader.close();
        LIBSDownsamplingInfo ds = new LIBSDownsamplingInfo(this.downsample, 250);
        LocusIteratorByState libs = new LocusIteratorByState((Iterator<GATKSAMRecord>)iterator, ds, true, genomeLocParser, samples, false);
        SimpleTimer timer = new SimpleTimer().start();
        int bp = 0;
        double lastElapsed = 0.0;
        while (libs.hasNext()) {
            AlignmentContext context = libs.next();
            ++bp;
            if (!(timer.getElapsedTime() - lastElapsed > 10.0)) continue;
            logger.info(bp + " iterations at " + context.getLocation());
            lastElapsed = timer.getElapsedTime();
        }
        logger.info(String.format("runtime in seconds: %.2f", timer.getElapsedTime()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int returnCode = 0;
        try {
            LIBSPerformance instance = new LIBSPerformance();
            LIBSPerformance.start(instance, argv);
            returnCode = 0;
        }
        catch (Exception ex) {
            returnCode = 1;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            System.exit(returnCode);
        }
    }
}

