/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.iterators;

import java.util.Iterator;

public class PushbackIterator<T>
implements Iterator<T>,
Iterable<T> {
    Iterator<T> underlyingIterator;
    T pushedElement = null;

    public PushbackIterator(Iterator<T> underlyingIterator) {
        this.underlyingIterator = underlyingIterator;
    }

    @Override
    public boolean hasNext() {
        return this.pushedElement != null || this.underlyingIterator.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public T element() {
        T x = this.next();
        this.pushback(x);
        return x;
    }

    @Override
    public T next() {
        if (this.pushedElement != null) {
            T ret = this.pushedElement;
            this.pushedElement = null;
            return ret;
        }
        return this.underlyingIterator.next();
    }

    public void pushback(T elt) {
        assert (this.pushedElement == null);
        this.pushedElement = elt;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<T> getUnderlyingIterator() {
        return this.underlyingIterator;
    }
}

