/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class Resource {
    private final String path;
    private final Class<?> relativeClass;
    private final ClassLoader relativeClassLoader;

    public Resource(String path, Class<?> relativeClass) {
        this.path = path;
        this.relativeClass = relativeClass;
        ClassLoader classLoader = null;
        if (relativeClass != null) {
            classLoader = relativeClass.getClassLoader();
        }
        this.relativeClassLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    public Class<?> getRelativeClass() {
        return this.relativeClass;
    }

    public ClassLoader getRelativeClassLoader() {
        return this.relativeClassLoader;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        if (this.relativeClass == null) {
            return this.path;
        }
        if (new File(this.path).isAbsolute()) {
            return this.path;
        }
        return String.format("%s%s%s", this.relativeClass.getPackage().getName().replace('.', File.separatorChar), File.separator, this.path);
    }

    public InputStream getResourceContentsAsStream() {
        InputStream inputStream;
        Class<?> clazz = this.getRelativeClass();
        if (clazz == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + this.path);
            }
        } else {
            inputStream = clazz.getResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found relative to " + clazz + ": " + this.path);
            }
        }
        return inputStream;
    }

    public List<InputStream> getAllResourcesContentsAsStreams() {
        ArrayList<InputStream> resourceStreams = new ArrayList<InputStream>();
        try {
            Enumeration<URL> resources = this.getRelativeClassLoader().getResources(this.path);
            while (resources.hasMoreElements()) {
                try {
                    resourceStreams.add(resources.nextElement().openStream());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resourceStreams.isEmpty()) {
            throw new IllegalArgumentException("Resource not found: " + this.path);
        }
        return resourceStreams;
    }

    public InputStream getAllResourcesContentsAsStream() {
        List<InputStream> resourceStreams = this.getAllResourcesContentsAsStreams();
        return new SequenceInputStream(Collections.enumeration(resourceStreams));
    }
}

