/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.help.DocletUtils;
import org.broadinstitute.gatk.utils.help.DocumentedGATKFeature;

public class ResourceBundleExtractorDoclet {
    public static final String VERSION_TAGLET_NAME = "version";
    public static final String SUMMARY_TAGLET_NAME = "help.summary";
    public static final String DESCRIPTION_TAGLET_NAME = "help.description";
    private final RootDoc rootDoc;
    private final Set<ClassDoc> classDocs;
    private final Set<PackageDoc> packageDocs;
    private final Set<Doc> allDocs;
    protected File outFile = null;
    protected String buildTimestamp = null;
    protected String absoluteVersion = null;

    public static boolean start(RootDoc rootDoc) throws IOException {
        ResourceBundleExtractorDoclet doclet = new ResourceBundleExtractorDoclet(rootDoc);
        doclet.checkUndocumentedClasses();
        if (doclet.isUpToDate()) {
            rootDoc.printNotice("Docs up to date. Not regenerating.");
            return true;
        }
        doclet.processDocs();
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-build-timestamp") || option.equals("-out") || option.equals("-absolute-version")) {
            return 2;
        }
        return 0;
    }

    private ResourceBundleExtractorDoclet(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        this.classDocs = new TreeSet<ClassDoc>();
        this.packageDocs = new TreeSet<PackageDoc>();
        this.allDocs = new TreeSet<Doc>();
        for (ClassDoc classDoc : rootDoc.classes()) {
            this.classDocs.add(classDoc);
            this.packageDocs.add(classDoc.containingPackage());
        }
        this.allDocs.addAll(this.classDocs);
        this.allDocs.addAll(this.packageDocs);
        for (ClassDoc classDoc : rootDoc.options()) {
            if (classDoc[0].equals("-out")) {
                this.outFile = new File((String)classDoc[1]);
            }
            if (classDoc[0].equals("-build-timestamp")) {
                this.buildTimestamp = classDoc[1];
            }
            if (!classDoc[0].equals("-absolute-version")) continue;
            this.absoluteVersion = classDoc[1];
        }
    }

    private void checkUndocumentedClasses() {
        TreeSet<String> undocumentedClasses = new TreeSet<String>();
        for (ClassDoc classDoc : this.classDocs) {
            if (!ResourceBundleExtractorDoclet.isRequiredJavadocMissing(classDoc) || !ResourceBundleExtractorDoclet.shouldDocument(classDoc)) continue;
            undocumentedClasses.add(classDoc.name());
        }
        if (undocumentedClasses.size() > 0) {
            String message = String.format("The following are currently undocumented: %s%s%s", "\u001b[5m", Utils.join(" ", undocumentedClasses), "\u001b[m");
            for (String line : Utils.warnUserLines(message)) {
                this.rootDoc.printWarning(line);
            }
        }
    }

    private boolean isUpToDate() {
        if (this.outFile == null) {
            return false;
        }
        long outFileMillis = this.outFile.lastModified();
        if (outFileMillis == 0L) {
            return false;
        }
        for (Doc doc : this.allDocs) {
            File docFile = doc.position() == null ? null : doc.position().file();
            if (docFile == null || docFile.lastModified() <= outFileMillis) continue;
            this.rootDoc.printNotice("At least one item is out of date: " + docFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDocs() throws IOException {
        PrintStream out = this.outFile != null ? new PrintStream(this.outFile) : System.out;
        try {
            Properties resourceText = new Properties();
            this.loadExistingResourceFile(resourceText);
            resourceText.setProperty("build.timestamp", this.buildTimestamp);
            for (ClassDoc currentClass : this.classDocs) {
                this.renderHelpText(resourceText, DocletUtils.getClassName((ProgramElementDoc)currentClass, false), (Doc)currentClass);
            }
            for (PackageDoc currentPackage : this.packageDocs) {
                this.renderHelpText(resourceText, currentPackage.name(), (Doc)currentPackage);
            }
            resourceText.store(out, "Strings displayed by the GATK help system");
        }
        finally {
            if (this.outFile != null) {
                out.close();
            }
        }
    }

    private void loadExistingResourceFile(Properties resourceText) throws IOException {
        try (BufferedReader resourceFile = new BufferedReader(new FileReader(this.outFile));){
            resourceText.load(resourceFile);
        }
        catch (FileNotFoundException e) {
            this.rootDoc.printNotice("Resource file not found -- generating a new one from scratch.");
        }
    }

    protected static boolean shouldDocument(ClassDoc classDoc) {
        Class docClass;
        if (classDoc.isAbstract()) {
            return false;
        }
        try {
            docClass = DocletUtils.getClassForDoc((ProgramElementDoc)classDoc);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        if (Throwable.class.isAssignableFrom(docClass)) {
            return false;
        }
        DocumentedGATKFeature f = docClass.getAnnotation(DocumentedGATKFeature.class);
        return f != null && f.enable();
    }

    private static boolean isRequiredJavadocMissing(ClassDoc classDoc) {
        return classDoc.commentText().length() == 0 || classDoc.commentText().contains("Created by IntelliJ");
    }

    private void renderHelpText(Properties resourceText, String elementName, Doc element) {
        StringBuilder summaryBuilder = new StringBuilder();
        for (Tag tag : element.firstSentenceTags()) {
            summaryBuilder.append(tag.text());
        }
        String summary = summaryBuilder.toString();
        String description = element.commentText();
        if (this.absoluteVersion != null) {
            resourceText.setProperty(String.format("%s.%s", elementName, VERSION_TAGLET_NAME), this.absoluteVersion);
        }
        resourceText.setProperty(String.format("%s.%s", elementName, SUMMARY_TAGLET_NAME), ResourceBundleExtractorDoclet.formatText(summary));
        resourceText.setProperty(String.format("%s.%s", elementName, DESCRIPTION_TAGLET_NAME), ResourceBundleExtractorDoclet.formatText(description));
    }

    private static String formatText(String text) {
        Scanner scanner = new Scanner(text);
        StringBuilder output = new StringBuilder();
        while (scanner.hasNextLine()) {
            if (output.length() > 0) {
                output.append(' ');
            }
            output.append(scanner.nextLine().trim());
        }
        return output.toString();
    }
}

