/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.help;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import htsjdk.tribble.FeatureCodec;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.help.DocletUtils;
import org.broadinstitute.gatk.utils.help.DocumentedGATKFeature;
import org.broadinstitute.gatk.utils.help.DocumentedGATKFeatureHandler;
import org.broadinstitute.gatk.utils.help.DocumentedGATKFeatureObject;
import org.broadinstitute.gatk.utils.help.ForumAPIUtils;
import org.broadinstitute.gatk.utils.help.GATKDocWorkUnit;
import org.broadinstitute.gatk.utils.help.GSONWorkUnit;
import org.broadinstitute.gatk.utils.text.XReadLines;

public abstract class GATKDoclet {
    protected static final Logger logger = Logger.getLogger(GATKDoclet.class);
    protected static final File SETTINGS_DIR = new File("settings/helpTemplates");
    protected static final File DESTINATION_DIR = new File("gatkdocs");
    private static final String FORUM_KEY_PATH = "/local/gsa-engineering/gatkdocs_publisher/forum.key";
    private static final String OUTPUT_FILE_EXTENSION = "html";
    private static final String OUTPUT_FILE_EXTENSION_OPTION = "-output-file-extension";
    protected static File settingsDir = SETTINGS_DIR;
    protected static File destinationDir = DESTINATION_DIR;
    protected static String forumKeyPath = "/local/gsa-engineering/gatkdocs_publisher/forum.key";
    protected static String buildTimestamp = null;
    protected static String absoluteVersion = null;
    protected static boolean showHiddenFeatures = false;
    protected static String outputFileExtension = "html";
    protected static boolean testOnly = false;
    RootDoc rootDoc;
    Set<GATKDocWorkUnit> myWorkUnits;
    static final Collection<DocumentedGATKFeatureObject> STATIC_DOCS = new ArrayList<DocumentedGATKFeatureObject>();

    protected boolean startProcessDocs(RootDoc rootDoc) throws IOException {
        logger.setLevel(Level.INFO);
        for (String[] options : rootDoc.options()) {
            if (options[0].equals("-settings-dir")) {
                settingsDir = new File(options[1]);
            }
            if (options[0].equals("-destination-dir")) {
                destinationDir = new File(options[1]);
            }
            if (options[0].equals("-forum-key-path")) {
                forumKeyPath = options[1];
            }
            if (options[0].equals("-build-timestamp")) {
                buildTimestamp = options[1];
            }
            if (options[0].equals("-absolute-version")) {
                absoluteVersion = options[1];
            }
            if (options[0].equals("-include-hidden")) {
                showHiddenFeatures = true;
            }
            if (options[0].equals("-test")) {
                testOnly = true;
            }
            if (!options[0].equals(OUTPUT_FILE_EXTENSION_OPTION)) continue;
            outputFileExtension = options[1];
        }
        if (!settingsDir.exists()) {
            throw new RuntimeException("-settings-dir " + settingsDir.getPath() + " does not exist");
        }
        if (!settingsDir.isDirectory()) {
            throw new RuntimeException("-settings-dir " + settingsDir.getPath() + " is not a directory");
        }
        this.processDocs(rootDoc);
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-settings-dir") || option.equals("-destination-dir") || option.equals("-forum-key-path") || option.equals("-build-timestamp") || option.equals("-absolute-version") || option.equals("-include-hidden") || option.equals(OUTPUT_FILE_EXTENSION_OPTION)) {
            return 2;
        }
        if (option.equals("-test")) {
            return 1;
        }
        return 0;
    }

    public boolean showHiddenFeatures() {
        return showHiddenFeatures;
    }

    protected List<Class<?>> getTestOnlyKeepers() {
        return Collections.singletonList(UserException.class);
    }

    private void processDocs(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        try {
            FileUtils.writeByteArrayToFile(new File(destinationDir + "/current.version.txt"), GATKDoclet.getSimpleVersion(absoluteVersion).getBytes());
            Configuration cfg = new Configuration();
            cfg.setDirectoryForTemplateLoading(settingsDir);
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            this.myWorkUnits = this.computeWorkUnits();
            ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
            HashSet<String> seenDocumentationFeatures = new HashSet<String>();
            ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
            for (GATKDocWorkUnit workUnit : this.myWorkUnits) {
                data.add(workUnit.indexDataMap());
                if (seenDocumentationFeatures.contains(workUnit.annotation.groupName())) continue;
                groups.add(GATKDoclet.toMap(workUnit.annotation));
                seenDocumentationFeatures.add(workUnit.annotation.groupName());
            }
            for (GATKDocWorkUnit workUnit : this.myWorkUnits) {
                this.processDocWorkUnit(cfg, workUnit, groups, data);
            }
            this.processIndex(cfg, new ArrayList<GATKDocWorkUnit>(this.myWorkUnits));
            File forumKeyFile = new File(forumKeyPath);
            if (forumKeyFile.exists()) {
                String forumKey = null;
                Iterator<String> iterator = new XReadLines(forumKeyFile).iterator();
                while (iterator.hasNext()) {
                    String line;
                    forumKey = line = iterator.next();
                }
                this.updateForum(this.myWorkUnits, forumKey);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateForum(Set<GATKDocWorkUnit> docWorkUnits, String forumKey) {
        List<String> old = ForumAPIUtils.getPostedTools(forumKey);
        for (String s : old) {
            System.out.printf("Forum has %d items%n", old.size());
        }
        System.out.printf("Docs have %d items%n", docWorkUnits.size());
        ArrayList<GATKDocWorkUnit> toAdd = new ArrayList<GATKDocWorkUnit>();
        for (GATKDocWorkUnit tool : docWorkUnits) {
            if (old.contains(tool.name)) continue;
            System.out.println("WILL POST: " + tool.name + " TO FORUM");
            toAdd.add(tool);
        }
        for (GATKDocWorkUnit tool : toAdd) {
            ForumAPIUtils.postToForum(tool, forumKey);
        }
    }

    private Set<GATKDocWorkUnit> computeWorkUnits() {
        TreeSet<GATKDocWorkUnit> m = new TreeSet<GATKDocWorkUnit>();
        for (ClassDoc doc : this.rootDoc.classes()) {
            DocumentedGATKFeatureObject feature;
            DocumentedGATKFeatureHandler handler;
            Class<? extends Object> clazz = this.getClassForClassDoc(doc);
            if (clazz != null && testOnly && !this.getTestOnlyKeepers().contains(clazz) || (handler = this.createHandler(doc, feature = this.getFeatureForClassDoc(doc))) == null || !handler.includeInDocs(doc)) continue;
            String filename = handler.getDestinationFilename(doc, clazz);
            GATKDocWorkUnit unit = new GATKDocWorkUnit(doc.name(), filename, feature.groupName(), feature, handler, doc, clazz, buildTimestamp, absoluteVersion);
            m.add(unit);
        }
        return m;
    }

    private DocumentedGATKFeatureHandler createHandler(ClassDoc doc, DocumentedGATKFeatureObject feature) {
        if (feature != null) {
            if (feature.enable()) {
                DocumentedGATKFeatureHandler handler = this.createDocumentedGATKFeatureHandler();
                handler.setDoclet(this);
                return handler;
            }
            logger.info("Skipping disabled Documentation for " + doc);
        }
        return null;
    }

    protected abstract DocumentedGATKFeatureHandler createDocumentedGATKFeatureHandler();

    private DocumentedGATKFeatureObject getFeatureForClassDoc(ClassDoc doc) {
        Class<? extends Object> docClass = this.getClassForClassDoc(doc);
        if (docClass == null) {
            return null;
        }
        if (docClass.isAnnotationPresent(DocumentedGATKFeature.class)) {
            DocumentedGATKFeature f = docClass.getAnnotation(DocumentedGATKFeature.class);
            return new DocumentedGATKFeatureObject(docClass, f.enable(), f.groupName(), f.summary(), f.extraDocs());
        }
        for (DocumentedGATKFeatureObject staticDocs : STATIC_DOCS) {
            if (!staticDocs.getClassToDoc().isAssignableFrom(docClass)) continue;
            return new DocumentedGATKFeatureObject(docClass, staticDocs.enable(), staticDocs.groupName(), staticDocs.summary(), staticDocs.extraDocs());
        }
        return null;
    }

    private Class<? extends Object> getClassForClassDoc(ClassDoc doc) {
        try {
            return DocletUtils.getClassForDoc((ProgramElementDoc)doc);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    private void processIndex(Configuration cfg, List<GATKDocWorkUnit> indexData) throws IOException {
        Template temp = cfg.getTemplate("generic.index.template.html");
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(destinationDir + "/index." + outputFileExtension)));
        try {
            temp.process(this.groupIndexData(indexData), (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException e) {
            throw new ReviewedGATKException("Failed to create GATK documentation", e);
        }
    }

    private Map<String, Object> groupIndexData(List<GATKDocWorkUnit> indexData) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Collections.sort(indexData);
        ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
        HashSet<String> seenDocumentationFeatures = new HashSet<String>();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (GATKDocWorkUnit workUnit : indexData) {
            data.add(workUnit.indexDataMap());
            if (seenDocumentationFeatures.contains(workUnit.annotation.groupName())) continue;
            groups.add(GATKDoclet.toMap(workUnit.annotation));
            seenDocumentationFeatures.add(workUnit.annotation.groupName());
        }
        root.put("data", data);
        root.put("groups", groups);
        root.put("timestamp", buildTimestamp);
        root.put("version", absoluteVersion);
        return root;
    }

    private static final Map<String, String> toMap(DocumentedGATKFeatureObject annotation) {
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("id", annotation.groupName().replaceAll("\\W", ""));
        root.put("name", annotation.groupName());
        root.put("summary", annotation.summary());
        String supercatValue = annotation.groupName().endsWith(" Tools") ? "tools" : (annotation.groupName().endsWith(" Utilities") ? "utilities" : (annotation.groupName().startsWith("Engine ") ? "engine" : (annotation.groupName().endsWith(" (Exclude)") ? "exclude" : "other")));
        root.put("supercat", supercatValue);
        return root;
    }

    public final GATKDocWorkUnit findWorkUnitForClass(Class c) {
        for (GATKDocWorkUnit unit : this.myWorkUnits) {
            if (!unit.clazz.equals(c)) continue;
            return unit;
        }
        return null;
    }

    public ClassDoc getClassDocForClass(Class clazz) {
        return this.rootDoc.classNamed(clazz.getName());
    }

    private void processDocWorkUnit(Configuration cfg, GATKDocWorkUnit unit, List<Map<String, String>> groups, List<Map<String, String>> data) throws IOException {
        unit.handler.processOne(unit);
        unit.forTemplate.put("groups", groups);
        unit.forTemplate.put("data", data);
        Template temp = cfg.getTemplate(unit.handler.getTemplateName(unit.classDoc));
        File outputPath = new File(destinationDir + "/" + unit.filename);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputPath));
            temp.process(unit.forTemplate, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException e) {
            throw new ReviewedGATKException("Failed to create GATK documentation", e);
        }
        GSONWorkUnit gsonworkunit = new GSONWorkUnit();
        gsonworkunit.populate(unit.forTemplate.get("summary").toString(), unit.forTemplate.get("parallel"), unit.forTemplate.get("activeregion"), unit.forTemplate.get("partitiontype").toString(), unit.forTemplate.get("walkertype").toString(), unit.forTemplate.get("gson-arguments"), unit.forTemplate.get("refwindow"), unit.forTemplate.get("description").toString(), unit.forTemplate.get("name").toString(), unit.forTemplate.get("annotinfo").toString(), unit.forTemplate.get("readfilters"), unit.forTemplate.get("downsampling"), unit.forTemplate.get("group").toString(), unit.forTemplate.get("annotfield").toString(), unit.forTemplate.get("annotdescript"));
        File outputPathForJSON = new File(destinationDir + "/" + unit.filename + ".json");
        try {
            BufferedWriter outJSON = new BufferedWriter(new FileWriter(outputPathForJSON));
            Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().create();
            String json = gson.toJson((Object)gsonworkunit);
            outJSON.write(json);
            outJSON.close();
        }
        catch (Exception e) {
            throw new ReviewedGATKException("Failed to create JSON entry", e);
        }
    }

    private static String getSimpleVersion(String absoluteVersion) {
        String[] parts = absoluteVersion.split("-");
        for (int i = 1; i < 2; ++i) {
            parts[0] = parts[0].concat("-");
            parts[0] = parts[0].concat(parts[i]);
        }
        return parts[0];
    }

    static {
        STATIC_DOCS.add(new DocumentedGATKFeatureObject(FeatureCodec.class, "Resource File Codecs", "Codecs for reading resource files in reference ordered data (ROD) files such as BED"));
    }
}

