/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.help;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.lang.reflect.Field;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;

public class DocletUtils {
    protected static boolean assignableToClass(ProgramElementDoc classDoc, Class lhsClass, boolean requireConcrete) {
        try {
            Class type = DocletUtils.getClassForDoc(classDoc);
            return lhsClass.isAssignableFrom(type) && (!requireConcrete || JVMUtils.isConcrete(type));
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static Class getClassForDoc(ProgramElementDoc doc) throws ClassNotFoundException {
        return Class.forName(DocletUtils.getClassName(doc, true));
    }

    protected static Field getFieldForFieldDoc(FieldDoc fieldDoc) {
        try {
            Class clazz = DocletUtils.getClassForDoc((ProgramElementDoc)fieldDoc.containingClass());
            return JVMUtils.findField(clazz, fieldDoc.name());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getClassName(ProgramElementDoc doc, boolean binaryName) {
        PackageDoc containingPackage = doc.containingPackage();
        String className = doc.name();
        if (binaryName) {
            className = className.replaceAll("\\.", "\\$");
        }
        return containingPackage.name().length() > 0 ? String.format("%s.%s", containingPackage.name(), className) : String.format("%s", className);
    }
}

