/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotypeBAMWriter;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.ReadDestination;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class DroppedReadsTracker {
    private final Map<Reason, Set<GATKSAMRecord>> droppedReads = new HashMap<Reason, Set<GATKSAMRecord>>(Reason.values().length);
    private static final HashFunction murmurHasher = Hashing.murmur3_32();

    public void addReads(Reason reason, Collection<GATKSAMRecord> reads) {
        Set<GATKSAMRecord> readsForReason = this.droppedReads.get((Object)reason);
        if (null == readsForReason) {
            readsForReason = new HashSet<GATKSAMRecord>(reads.size());
        }
        for (GATKSAMRecord rec : reads) {
            if (this.previouslyDropped(rec)) continue;
            rec.setAttribute(SAMTag.FT.name(), (Object)reason.reasonName());
            readsForReason.add(rec);
        }
        this.droppedReads.put(reason, readsForReason);
    }

    public void addReadsFromDelta(Reason reason, Collection<GATKSAMRecord> preReads, Collection<GATKSAMRecord> postReads) {
        GATKSAMRecordHashWrapper hashWrapper;
        HashSet<GATKSAMRecordHashWrapper> postReadsSet = new HashSet<GATKSAMRecordHashWrapper>(postReads.size());
        for (GATKSAMRecord postRead : postReads) {
            hashWrapper = new GATKSAMRecordHashWrapper(postRead);
            postReadsSet.add(hashWrapper);
        }
        int estimatedDropSize = preReads.size() - postReads.size();
        ArrayList<GATKSAMRecord> newlyDropped = new ArrayList<GATKSAMRecord>(estimatedDropSize > 0 ? estimatedDropSize : 5);
        hashWrapper = new GATKSAMRecordHashWrapper();
        for (GATKSAMRecord preRead : preReads) {
            if (postReadsSet.contains(hashWrapper.set(preRead))) continue;
            newlyDropped.add(preRead);
        }
        this.addReads(reason, newlyDropped);
    }

    public void writeDroppedReads(ReadDestination readDestination) {
        for (Reason reason : this.droppedReads.keySet()) {
            Set<GATKSAMRecord> droppedRecords = this.droppedReads.get((Object)reason);
            for (GATKSAMRecord originalRec : droppedRecords) {
                GATKSAMRecord clonedRec = (GATKSAMRecord)originalRec.clone();
                clonedRec.setReadFailsVendorQualityCheckFlag(true);
                readDestination.add(clonedRec);
            }
        }
        this.droppedReads.clear();
    }

    private boolean previouslyDropped(GATKSAMRecord rec) {
        String reasonDesc = rec.getStringAttribute(SAMTag.FT.name());
        for (Reason reason : Reason.values()) {
            if (!reason.reasonName().equals(reasonDesc)) continue;
            return true;
        }
        return false;
    }

    private class GATKSAMRecordHashWrapper {
        private GATKSAMRecord samRec;

        public GATKSAMRecordHashWrapper() {
            this.samRec = null;
        }

        public GATKSAMRecordHashWrapper(GATKSAMRecord rec) {
            this.samRec = rec;
        }

        public GATKSAMRecordHashWrapper set(GATKSAMRecord rec) {
            this.samRec = rec;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GATKSAMRecordHashWrapper)) {
                return false;
            }
            GATKSAMRecord other = ((GATKSAMRecordHashWrapper)o).samRec;
            return this.samRec.getReadName().equals(other.getReadName()) && this.samRec.getFlags() == other.getFlags();
        }

        public int hashCode() {
            return this.samRec.getReadName().hashCode() + 31 * murmurHasher.hashLong((long)this.samRec.getFlags()).asInt();
        }
    }

    public static enum Reason {
        TRIMMMED{

            @Override
            String reasonName() {
                return "Trimmed";
            }
        }
        ,
        DOWNSAMPLED{

            @Override
            String reasonName() {
                return "Downsampled";
            }
        }
        ,
        REALIGNMENT_FAILURE{

            @Override
            String reasonName() {
                return "Failed realignment";
            }
        }
        ,
        FILTERED{

            @Override
            String reasonName() {
                return "Filtered";
            }
        }
        ,
        NOT_INFORMATIVE{

            @Override
            String reasonName() {
                return "Not informative";
            }
        };


        abstract String reasonName();
    }
}

