/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.gvcf;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.gatk.utils.MathUtils;

final class HomRefBlock {
    private final VariantContext startingVC;
    private int stop;
    private final int minGQ;
    private final int maxGQ;
    private int[] minPLs = null;
    private final List<Integer> GQs = new ArrayList<Integer>(100);
    private final List<Integer> DPs = new ArrayList<Integer>(100);
    private final Allele ref;
    private final int ploidy;

    public HomRefBlock(VariantContext startingVC, int minGQ, int maxGQ, int defaultPloidy) {
        if (startingVC == null) {
            throw new IllegalArgumentException("startingVC cannot be null");
        }
        if (minGQ > maxGQ) {
            throw new IllegalArgumentException("bad minGQ " + minGQ + " as its > maxGQ " + maxGQ);
        }
        this.startingVC = startingVC;
        this.stop = this.getStart() - 1;
        this.ref = startingVC.getReference();
        this.minGQ = minGQ;
        this.maxGQ = maxGQ;
        this.ploidy = startingVC.getMaxPloidy(defaultPloidy);
    }

    public HomRefBlock(int minGQ, int maxGQ, int ploidy) {
        if (minGQ > maxGQ) {
            throw new IllegalArgumentException("bad minGQ " + minGQ + " as its > maxGQ " + maxGQ);
        }
        this.startingVC = null;
        this.stop = -1;
        this.ref = null;
        this.minGQ = minGQ;
        this.maxGQ = maxGQ;
        this.ploidy = ploidy;
    }

    public void add(int pos, Genotype g) {
        if (g == null) {
            throw new IllegalArgumentException("g cannot be null");
        }
        if (!g.hasGQ()) {
            throw new IllegalArgumentException("g must have GQ field");
        }
        if (!g.hasPL()) {
            throw new IllegalArgumentException("g must have PL field");
        }
        if (pos != this.stop + 1) {
            throw new IllegalArgumentException("adding genotype at pos " + pos + " isn't contiguous with previous stop " + this.stop);
        }
        if (g.getPloidy() != this.ploidy) {
            throw new IllegalArgumentException("cannot add a genotype with a different ploidy: " + g.getPloidy() + " != " + this.ploidy);
        }
        if (this.minPLs == null) {
            this.minPLs = g.getPL();
        } else {
            int[] PL = g.getPL();
            if (PL.length != this.minPLs.length) {
                throw new IllegalStateException("trying to merge different PL array sizes: " + PL.length + " != " + this.minPLs.length);
            }
            for (int i = 0; i < PL.length; ++i) {
                if (this.minPLs[i] <= PL[i]) continue;
                this.minPLs[i] = PL[i];
            }
        }
        this.stop = pos;
        this.GQs.add(Math.min(g.getGQ(), 99));
        this.DPs.add(Math.max(g.getDP(), 0));
    }

    public boolean withinBounds(int GQ) {
        return GQ >= this.minGQ && GQ < this.maxGQ;
    }

    public int getMinGQ() {
        return MathUtils.arrayMin(this.GQs);
    }

    public int getMedianGQ() {
        return MathUtils.median(this.GQs);
    }

    public int getMinDP() {
        return MathUtils.arrayMin(this.DPs);
    }

    public int getMedianDP() {
        return MathUtils.median(this.DPs);
    }

    public int[] getMinPLs() {
        return this.minPLs;
    }

    protected int getGQUpperBound() {
        return this.maxGQ;
    }

    protected int getGQLowerBound() {
        return this.minGQ;
    }

    public boolean isContiguous(VariantContext vc) {
        return vc.getEnd() == this.getStop() + 1 && this.startingVC.getChr().equals(vc.getChr());
    }

    public VariantContext getStartingVC() {
        return this.startingVC;
    }

    public int getStart() {
        return this.startingVC.getStart();
    }

    public int getStop() {
        return this.stop;
    }

    public Allele getRef() {
        return this.ref;
    }

    public int getSize() {
        return this.getStop() - this.getStart() + 1;
    }

    public String toString() {
        return "HomRefBlock{minGQ=" + this.minGQ + ", maxGQ=" + this.maxGQ + '}';
    }

    public VCFHeaderLine toVCFHeaderLine() {
        String key = String.format("GVCFBlock%d-%d", this.getGQLowerBound(), this.getGQUpperBound());
        return new VCFHeaderLine(key, "minGQ=" + this.getGQLowerBound() + "(inclusive),maxGQ=" + this.getGQUpperBound() + "(exclusive)");
    }

    public int getPloidy() {
        return this.ploidy;
    }
}

