/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.gvcf;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.gvcf.HomRefBlock;
import org.broadinstitute.gatk.utils.variant.GATKVCFConstants;
import org.broadinstitute.gatk.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.gatk.utils.variant.GATKVariantContextUtils;

public class GVCFWriter
implements VariantContextWriter {
    private static final int MAX_GENOTYPE_QUAL = 99;
    private final VariantContextWriter underlyingWriter;
    private final List<HomRefBlock> GQPartitions;
    int nextAvailableStart = -1;
    String contigOfNextAvailableStart = null;
    private String sampleName = null;
    private HomRefBlock currentBlock = null;
    private final int defaultPloidy;

    protected static List<HomRefBlock> parsePartitions(List<Integer> GQPartitions, int defaultPloidy) {
        if (GQPartitions == null) {
            throw new IllegalArgumentException("The list of GQ partitions cannot be null.");
        }
        if (GQPartitions.isEmpty()) {
            throw new IllegalArgumentException("The list of GQ partitions cannot be empty.");
        }
        LinkedList<HomRefBlock> result = new LinkedList<HomRefBlock>();
        int lastThreshold = 0;
        for (Integer value : GQPartitions) {
            if (value == null || value <= 0) {
                throw new IllegalArgumentException("The list of GQ partitions contains a null or non-positive integer.");
            }
            if (value < lastThreshold) {
                throw new IllegalArgumentException(String.format("The list of GQ partitions is out of order. Previous value is %d but the next is %d.", lastThreshold, value));
            }
            if (value == lastThreshold) {
                throw new IllegalArgumentException(String.format("The value %d appears more than once in the list of GQ partitions.", value));
            }
            if (value > 100) {
                throw new IllegalArgumentException(String.format("The value %d in the list of GQ partitions is greater than VCFConstants.MAX_GENOTYPE_QUAL + 1 = %d.", value, 100));
            }
            result.add(new HomRefBlock(lastThreshold, value, defaultPloidy));
            lastThreshold = value;
        }
        if (lastThreshold <= 99) {
            result.add(new HomRefBlock(lastThreshold, 100, defaultPloidy));
        }
        return result;
    }

    public GVCFWriter(VariantContextWriter underlyingWriter, List<Integer> GQPartitions, int defaultPloidy) {
        if (underlyingWriter == null) {
            throw new IllegalArgumentException("underlyingWriter cannot be null");
        }
        this.underlyingWriter = underlyingWriter;
        this.GQPartitions = GVCFWriter.parsePartitions(GQPartitions, defaultPloidy);
        this.defaultPloidy = defaultPloidy;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        header.addMetaDataLine(VCFStandardHeaderLines.getInfoLine("END"));
        header.addMetaDataLine(GATKVCFHeaderLines.getFormatLine("MIN_DP"));
        for (HomRefBlock partition : this.GQPartitions) {
            header.addMetaDataLine(partition.toVCFHeaderLine());
        }
        this.underlyingWriter.writeHeader(header);
    }

    @Override
    public void close() {
        this.close(true);
    }

    public void close(boolean closeUnderlyingWriter) {
        this.emitCurrentBlock();
        if (closeUnderlyingWriter) {
            this.underlyingWriter.close();
        }
    }

    protected VariantContext addHomRefSite(VariantContext vc, Genotype g) {
        VariantContext result;
        if (this.nextAvailableStart != -1) {
            if (vc.getStart() <= this.nextAvailableStart && vc.getChr().equals(this.contigOfNextAvailableStart)) {
                return null;
            }
            this.nextAvailableStart = -1;
            this.contigOfNextAvailableStart = null;
        }
        if (this.genotypeCanBeMergedInCurrentBlock(g)) {
            this.currentBlock.add(vc.getStart(), g);
            result = null;
        } else {
            result = this.blockToVCF(this.currentBlock);
            this.currentBlock = this.createNewBlock(vc, g);
        }
        return result;
    }

    private boolean genotypeCanBeMergedInCurrentBlock(Genotype g) {
        return this.currentBlock != null && this.currentBlock.withinBounds(this.capToMaxGQ(g.getGQ())) && this.currentBlock.getPloidy() == g.getPloidy() && (this.currentBlock.getMinPLs() == null || !g.hasPL() || this.currentBlock.getMinPLs().length == g.getPL().length);
    }

    private int capToMaxGQ(int gq) {
        return Math.min(gq, 99);
    }

    private void emitCurrentBlock() {
        if (this.currentBlock != null) {
            this.underlyingWriter.add(this.blockToVCF(this.currentBlock));
            this.currentBlock = null;
        }
    }

    private VariantContext blockToVCF(HomRefBlock block) {
        if (block == null) {
            return null;
        }
        VariantContextBuilder vcb = new VariantContextBuilder(block.getStartingVC());
        vcb.attributes(new HashMap(2));
        vcb.stop(block.getStop());
        vcb.attribute("END", block.getStop());
        GenotypeBuilder gb = new GenotypeBuilder(this.sampleName, GATKVariantContextUtils.homozygousAlleleList(block.getRef(), block.getPloidy()));
        gb.noAD().noPL().noAttributes();
        int[] minPLs = block.getMinPLs();
        gb.PL(minPLs);
        int gq = GATKVariantContextUtils.calculateGQFromPLs(minPLs);
        gb.GQ(gq);
        gb.DP(block.getMedianDP());
        gb.attribute("MIN_DP", block.getMinDP());
        return vcb.genotypes(gb.make()).make();
    }

    private HomRefBlock createNewBlock(VariantContext vc, Genotype g) {
        HomRefBlock partition = null;
        for (HomRefBlock maybePartition : this.GQPartitions) {
            if (!maybePartition.withinBounds(this.capToMaxGQ(g.getGQ()))) continue;
            partition = maybePartition;
            break;
        }
        if (partition == null) {
            throw new IllegalStateException("GQ " + g + " from " + vc + " didn't fit into any partition");
        }
        HomRefBlock block = new HomRefBlock(vc, partition.getGQLowerBound(), partition.getGQUpperBound(), this.defaultPloidy);
        block.add(vc.getStart(), g);
        return block;
    }

    @Override
    public void add(VariantContext vc) {
        Genotype g;
        if (vc == null) {
            throw new IllegalArgumentException("vc cannot be null");
        }
        if (this.sampleName == null) {
            this.sampleName = vc.getGenotype(0).getSampleName();
        }
        if (!vc.hasGenotypes()) {
            throw new IllegalArgumentException("GVCF assumes that the VariantContext has genotypes");
        }
        if (vc.getGenotypes().size() != 1) {
            throw new IllegalArgumentException("GVCF assumes that the VariantContext has exactly one genotype but saw " + vc.getGenotypes().size());
        }
        if (this.currentBlock != null && !this.currentBlock.isContiguous(vc)) {
            this.emitCurrentBlock();
        }
        if ((g = vc.getGenotype(0)).isHomRef() && vc.hasAlternateAllele(GATKVCFConstants.NON_REF_SYMBOLIC_ALLELE) && vc.isBiallelic()) {
            VariantContext maybeCompletedBand = this.addHomRefSite(vc, g);
            if (maybeCompletedBand != null) {
                this.underlyingWriter.add(maybeCompletedBand);
            }
        } else {
            this.emitCurrentBlock();
            this.nextAvailableStart = vc.getEnd();
            this.contigOfNextAvailableStart = vc.getChr();
            this.underlyingWriter.add(vc);
        }
    }

    @Override
    public boolean checkError() {
        return false;
    }
}

