/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.gga;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.refdata.RefMetaDataTracker;
import org.broadinstitute.gatk.utils.variant.GATKVariantContextUtils;

public class GenotypingGivenAllelesUtils {
    public static VariantContext composeGivenAllelesVariantContextFromRod(RefMetaDataTracker tracker, GenomeLoc loc, boolean snpsOnly, Logger logger, RodBinding<VariantContext> allelesBinding) {
        if (tracker == null) {
            throw new IllegalArgumentException("the tracker cannot be null");
        }
        if (loc == null) {
            throw new IllegalArgumentException("the location cannot be null");
        }
        if (allelesBinding == null) {
            throw new IllegalArgumentException("the alleles binding cannot be null");
        }
        VariantContext vc = null;
        for (VariantContext rodVc : tracker.getValues(allelesBinding, loc)) {
            if (rodVc == null || rodVc.isFiltered() || snpsOnly && !rodVc.isSNP()) continue;
            if (vc == null) {
                vc = rodVc;
                continue;
            }
            if (logger == null) continue;
            logger.warn("Multiple valid VCF records detected in the alleles input file at site " + loc + ", only considering the first record");
        }
        return vc;
    }

    public static List<Haplotype> composeGivenHaplotypes(Haplotype refHaplotype, List<VariantContext> givenHaplotypes, GenomeLoc activeRegionWindow) {
        if (refHaplotype == null) {
            throw new IllegalArgumentException("the reference haplotype cannot be null");
        }
        if (givenHaplotypes == null) {
            throw new IllegalArgumentException("given haplotypes cannot be null");
        }
        if (activeRegionWindow == null) {
            throw new IllegalArgumentException("active region window cannot be null");
        }
        if (activeRegionWindow.size() != refHaplotype.length()) {
            throw new IllegalArgumentException("inconsistent reference haplotype and active region window");
        }
        LinkedHashSet<Haplotype> returnHaplotypes = new LinkedHashSet<Haplotype>();
        int activeRegionStart = refHaplotype.getAlignmentStartHapwrtRef();
        for (VariantContext compVC : givenHaplotypes) {
            if (!GATKVariantContextUtils.overlapsRegion(compVC, activeRegionWindow)) {
                throw new IllegalArgumentException(" some variant provided does not overlap with active region window");
            }
            for (Allele compAltAllele : compVC.getAlternateAlleles()) {
                Haplotype insertedRefHaplotype = refHaplotype.insertAllele(compVC.getReference(), compAltAllele, activeRegionStart + compVC.getStart() - activeRegionWindow.getStart(), compVC.getStart());
                if (insertedRefHaplotype == null) continue;
                returnHaplotypes.add(insertedRefHaplotype);
            }
        }
        return new ArrayList<Haplotype>(returnHaplotypes);
    }
}

