/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.genotyper;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.broadinstitute.gatk.utils.genotyper.SampleList;

public class SampleListUtils {
    private static final SampleList EMPTY_LIST = new SampleList(){

        @Override
        public int sampleCount() {
            return 0;
        }

        @Override
        public int sampleIndex(String sample) {
            return -1;
        }

        @Override
        public String sampleAt(int sampleIndex) {
            throw new IllegalArgumentException("index is out of valid range");
        }
    };

    public static SampleList emptyList() {
        return EMPTY_LIST;
    }

    public static boolean equals(SampleList first, SampleList second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("no null list allowed");
        }
        int sampleCount = first.sampleCount();
        if (sampleCount != second.sampleCount()) {
            return false;
        }
        for (int i = 0; i < sampleCount; ++i) {
            String firstSample = first.sampleAt(i);
            if (firstSample == null) {
                throw new IllegalStateException("no null samples allowed in sample-lists: first list at " + i);
            }
            String secondSample = second.sampleAt(i);
            if (secondSample == null) {
                throw new IllegalArgumentException("no null samples allowed in sample-list: second list at " + i);
            }
            if (firstSample.equals(secondSample)) continue;
            return false;
        }
        return true;
    }

    public static List<String> asList(SampleList list) {
        if (list == null) {
            throw new IllegalArgumentException("the list cannot be null");
        }
        return new AsList(list);
    }

    public static Set<String> asSet(SampleList list) {
        if (list == null) {
            throw new IllegalArgumentException("the list cannot be null");
        }
        return new AsSet(list);
    }

    public static SampleList singletonList(final String sampleName) {
        if (sampleName == null) {
            throw new IllegalArgumentException("the sample name cannot be null");
        }
        return new SampleList(){

            @Override
            public int sampleCount() {
                return 1;
            }

            @Override
            public int sampleIndex(String sample) {
                return sampleName.equals(sample) ? 0 : -1;
            }

            @Override
            public String sampleAt(int sampleIndex) {
                if (sampleIndex == 0) {
                    return sampleName;
                }
                throw new IllegalArgumentException("index is out of bounds");
            }
        };
    }

    private static class AsSet
    extends AbstractSet<String> {
        private final SampleList list;

        private AsSet(SampleList list) {
            this.list = list;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < list.sampleCount();
                }

                @Override
                public String next() {
                    if (this.index >= list.sampleCount()) {
                        throw new NoSuchElementException("iterating beyond sample list end");
                    }
                    return list.sampleAt(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("unsupported operation exception");
                }
            };
        }

        @Override
        public int size() {
            return this.list.sampleCount();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof String) {
                return this.list.sampleIndex((String)obj) >= 0;
            }
            return false;
        }
    }

    private static class AsList
    extends AbstractList<String> {
        private final SampleList list;

        private AsList(SampleList list) {
            this.list = list;
        }

        @Override
        public String get(int index) {
            return this.list.sampleAt(index);
        }

        @Override
        public int size() {
            return this.list.sampleCount();
        }
    }
}

