/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.genotyper;

import com.google.java.contract.Ensures;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.downsampling.AlleleBiasedDownsamplingUtils;
import org.broadinstitute.gatk.utils.genotyper.MostLikelyAllele;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileup;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class PerReadAlleleLikelihoodMap {
    private final Map<Allele, Integer> allelesSet = new HashMap<Allele, Integer>();
    protected final List<Allele> alleles = new ArrayList<Allele>();
    protected final Map<GATKSAMRecord, Map<Allele, Double>> likelihoodReadMap = new LinkedHashMap<GATKSAMRecord, Map<Allele, Double>>();

    public void add(GATKSAMRecord read, Allele a, Double likelihood) {
        Map<Allele, Double> likelihoodMap;
        if (read == null) {
            throw new IllegalArgumentException("Cannot add a null read to the allele likelihood map");
        }
        if (a == null) {
            throw new IllegalArgumentException("Cannot add a null allele to the allele likelihood map");
        }
        if (likelihood == null) {
            throw new IllegalArgumentException("Likelihood cannot be null");
        }
        if (likelihood > 0.0) {
            throw new IllegalArgumentException("Likelihood must be negative (L = log(p))");
        }
        if (!this.allelesSet.containsKey(a)) {
            this.allelesSet.put(a, this.alleles.size());
            this.alleles.add(a);
        }
        if ((likelihoodMap = this.likelihoodReadMap.get(read)) == null) {
            likelihoodMap = new LinkedHashMap<Allele, Double>();
            this.likelihoodReadMap.put(read, likelihoodMap);
        }
        likelihoodMap.put(a, likelihood);
    }

    public ReadBackedPileup createPerAlleleDownsampledBasePileup(ReadBackedPileup pileup, double downsamplingFraction) {
        return AlleleBiasedDownsamplingUtils.createAlleleBiasedBasePileup(pileup, downsamplingFraction);
    }

    public void performPerAlleleDownsampling(double downsamplingFraction) {
        if (downsamplingFraction <= 0.0) {
            return;
        }
        if (downsamplingFraction >= 1.0) {
            this.likelihoodReadMap.clear();
            return;
        }
        Map<Allele, List<GATKSAMRecord>> alleleReadMap = this.getAlleleStratifiedReadMap();
        List<GATKSAMRecord> readsToRemove = AlleleBiasedDownsamplingUtils.selectAlleleBiasedReads(alleleReadMap, downsamplingFraction);
        for (GATKSAMRecord read : readsToRemove) {
            this.likelihoodReadMap.remove(read);
        }
    }

    protected Map<Allele, List<GATKSAMRecord>> getAlleleStratifiedReadMap() {
        HashMap<Allele, List<GATKSAMRecord>> alleleReadMap = new HashMap<Allele, List<GATKSAMRecord>>(this.alleles.size());
        for (Allele allele : this.alleles) {
            alleleReadMap.put(allele, new ArrayList());
        }
        for (Map.Entry entry : this.likelihoodReadMap.entrySet()) {
            MostLikelyAllele bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele((Map)entry.getValue());
            if (!bestAllele.isInformative()) continue;
            ((List)alleleReadMap.get(bestAllele.getMostLikelyAllele())).add(entry.getKey());
        }
        return alleleReadMap;
    }

    @Ensures(value={"result >=0"})
    public int size() {
        return this.likelihoodReadMap.size();
    }

    public void add(PileupElement p, Allele a, Double likelihood) {
        if (p == null) {
            throw new IllegalArgumentException("Pileup element cannot be null");
        }
        if (p.getRead() == null) {
            throw new IllegalArgumentException("Read underlying pileup element cannot be null");
        }
        if (a == null) {
            throw new IllegalArgumentException("Allele for add() cannot be null");
        }
        this.add(p.getRead(), a, likelihood);
    }

    public boolean containsPileupElement(PileupElement p) {
        return this.likelihoodReadMap.containsKey(p.getRead());
    }

    public boolean isEmpty() {
        return this.likelihoodReadMap.isEmpty();
    }

    public Map<GATKSAMRecord, Map<Allele, Double>> getLikelihoodReadMap() {
        return this.likelihoodReadMap;
    }

    public void clear() {
        this.allelesSet.clear();
        this.alleles.clear();
        this.likelihoodReadMap.clear();
    }

    public Set<GATKSAMRecord> getStoredElements() {
        return this.likelihoodReadMap.keySet();
    }

    public int getNumberOfStoredElements() {
        return this.likelihoodReadMap.size();
    }

    public Map<Allele, Double> getLikelihoodsAssociatedWithPileupElement(PileupElement p) {
        if (!this.likelihoodReadMap.containsKey(p.getRead())) {
            return null;
        }
        return this.likelihoodReadMap.get(p.getRead());
    }

    public double getLikelihoodAssociatedWithReadAndAllele(GATKSAMRecord read, Allele allele) {
        if (!this.allelesSet.containsKey(allele) || !this.likelihoodReadMap.containsKey(read)) {
            return 0.0;
        }
        return this.likelihoodReadMap.get(read).get(allele);
    }

    public MostLikelyAllele getMostLikelyDiploidAlleles() {
        if (this.isEmpty()) {
            return null;
        }
        int hap1 = 0;
        int hap2 = 0;
        double maxElement = Double.NEGATIVE_INFINITY;
        for (int iii = 0; iii < this.alleles.size(); ++iii) {
            Allele iii_allele = this.alleles.get(iii);
            for (int jjj = 0; jjj <= iii; ++jjj) {
                double likelihood_jjj;
                Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry;
                double likelihood_iii;
                Allele jjj_allele = this.alleles.get(jjj);
                double haplotypeLikelihood = 0.0;
                Iterator<Map.Entry<GATKSAMRecord, Map<Allele, Double>>> iterator = this.likelihoodReadMap.entrySet().iterator();
                while (iterator.hasNext() && !((haplotypeLikelihood += MathUtils.approximateLog10SumLog10(likelihood_iii = (entry = iterator.next()).getValue().get(iii_allele).doubleValue(), likelihood_jjj = entry.getValue().get(jjj_allele).doubleValue()) + MathUtils.LOG_ONE_HALF) < maxElement)) {
                }
                if (!(haplotypeLikelihood > maxElement)) continue;
                hap1 = iii;
                hap2 = jjj;
                maxElement = haplotypeLikelihood;
            }
        }
        if (maxElement == Double.NEGATIVE_INFINITY) {
            throw new IllegalStateException("max likelihood is " + maxElement + " indicating something has gone wrong");
        }
        return new MostLikelyAllele(this.alleles.get(hap1), this.alleles.get(hap2), maxElement, maxElement);
    }

    @Ensures(value={"result != null"})
    public static MostLikelyAllele getMostLikelyAllele(Map<Allele, Double> alleleMap) {
        return PerReadAlleleLikelihoodMap.getMostLikelyAllele(alleleMap, null);
    }

    public static MostLikelyAllele getMostLikelyAllele(Map<Allele, Double> alleleMap, Set<Allele> onlyConsiderTheseAlleles) {
        if (alleleMap == null) {
            throw new IllegalArgumentException("The allele to likelihood map cannot be null");
        }
        double maxLike = Double.NEGATIVE_INFINITY;
        double prevMaxLike = Double.NEGATIVE_INFINITY;
        Allele mostLikelyAllele = Allele.NO_CALL;
        Allele secondMostLikely = null;
        for (Map.Entry<Allele, Double> el : alleleMap.entrySet()) {
            if (onlyConsiderTheseAlleles != null && !onlyConsiderTheseAlleles.contains(el.getKey())) continue;
            if (el.getValue() > maxLike) {
                prevMaxLike = maxLike;
                maxLike = el.getValue();
                secondMostLikely = mostLikelyAllele;
                mostLikelyAllele = el.getKey();
                continue;
            }
            if (!(el.getValue() > prevMaxLike)) continue;
            secondMostLikely = el.getKey();
            prevMaxLike = el.getValue();
        }
        return new MostLikelyAllele(mostLikelyAllele, secondMostLikely, maxLike, prevMaxLike);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alelles in map:");
        for (Allele allele : this.alleles) {
            sb.append(allele.getDisplayString() + ",");
        }
        sb.append("\n");
        for (Map.Entry entry : this.getLikelihoodReadMap().entrySet()) {
            for (Map.Entry eli : ((Map)entry.getValue()).entrySet()) {
                sb.append("Read " + ((GATKSAMRecord)entry.getKey()).getReadName() + ". Allele:" + ((Allele)eli.getKey()).getDisplayString() + " has likelihood=" + Double.toString((Double)eli.getValue()) + "\n");
            }
        }
        return sb.toString();
    }

    public List<GATKSAMRecord> filterPoorlyModelledReads(double maxErrorRatePerBase) {
        LinkedList<GATKSAMRecord> removedReads = new LinkedList<GATKSAMRecord>();
        Iterator<Map.Entry<GATKSAMRecord, Map<Allele, Double>>> it = this.likelihoodReadMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<GATKSAMRecord, Map<Allele, Double>> record = it.next();
            if (!this.readIsPoorlyModelled(record.getKey(), record.getValue().values(), maxErrorRatePerBase)) continue;
            it.remove();
            removedReads.add(record.getKey());
        }
        return removedReads;
    }

    protected boolean readIsPoorlyModelled(GATKSAMRecord read, Collection<Double> log10Likelihoods, double maxErrorRatePerBase) {
        double maxErrorsForRead = Math.min(2.0, Math.ceil((double)read.getReadLength() * maxErrorRatePerBase));
        double log10QualPerBase = -4.0;
        double log10MaxLikelihoodForTrueAllele = maxErrorsForRead * -4.0;
        for (double log10Likelihood : log10Likelihoods) {
            if (!(log10Likelihood >= log10MaxLikelihoodForTrueAllele)) continue;
            return false;
        }
        return true;
    }

    public Set<Allele> getAllelesSet() {
        return Collections.unmodifiableSet(this.allelesSet.keySet());
    }

    public void realignReadsToMostLikelyHaplotype(Collection<Haplotype> haplotypes, GenomeLoc paddedReferenceLoc) {
        HashMap<Allele, Haplotype> alleleToHaplotypeMap = new HashMap<Allele, Haplotype>(haplotypes.size());
        Haplotype refHaplotype = null;
        for (Haplotype haplotype : haplotypes) {
            alleleToHaplotypeMap.put(Allele.create(haplotype.getBases()), haplotype);
            if (refHaplotype != null || !haplotype.isReference()) continue;
            refHaplotype = haplotype;
        }
        LinkedHashMap<GATKSAMRecord, Map<Allele, Double>> newLikelihoodReadMap = new LinkedHashMap<GATKSAMRecord, Map<Allele, Double>>(this.likelihoodReadMap.size());
        for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry : this.likelihoodReadMap.entrySet()) {
            MostLikelyAllele bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele(entry.getValue());
            GATKSAMRecord alignedToRef = AlignmentUtils.createReadAlignedToRef(entry.getKey(), (Haplotype)alleleToHaplotypeMap.get(bestAllele.getMostLikelyAllele()), refHaplotype, paddedReferenceLoc.getStart(), bestAllele.isInformative());
            newLikelihoodReadMap.put(alignedToRef, entry.getValue());
        }
        this.likelihoodReadMap.clear();
        this.likelihoodReadMap.putAll(newLikelihoodReadMap);
    }
}

