/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.AbstractList;
import java.util.List;
import org.broadinstitute.gatk.utils.genotyper.AlleleList;
import org.broadinstitute.gatk.utils.genotyper.AlleleListPermutation;

public class AlleleListUtils {
    private static final AlleleList EMPTY_LIST = new AlleleList(){

        @Override
        public int alleleCount() {
            return 0;
        }

        public int alleleIndex(Allele allele) {
            return -1;
        }

        public Allele alleleAt(int index) {
            throw new IllegalArgumentException("allele index is out of range");
        }
    };

    public static <A extends Allele> boolean equals(AlleleList<A> first, AlleleList<A> second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("no null list allowed");
        }
        int alleleCount = first.alleleCount();
        if (alleleCount != second.alleleCount()) {
            return false;
        }
        for (int i = 0; i < alleleCount; ++i) {
            A firstSample = first.alleleAt(i);
            if (firstSample == null) {
                throw new IllegalStateException("no null samples allowed in sample-lists: first list at " + i);
            }
            A secondSample = second.alleleAt(i);
            if (secondSample == null) {
                throw new IllegalArgumentException("no null samples allowed in sample-list: second list at " + i);
            }
            if (((Allele)firstSample).equals(secondSample)) continue;
            return false;
        }
        return true;
    }

    public static <A extends Allele> int indexOfReference(AlleleList<A> list) {
        if (list == null) {
            throw new IllegalArgumentException("the input list cannot be null");
        }
        int alleleCount = list.alleleCount();
        for (int i = 0; i < alleleCount; ++i) {
            if (!((Allele)list.alleleAt(i)).isReference()) continue;
            return i;
        }
        return -1;
    }

    public static <A extends Allele> List<A> asList(AlleleList<A> list) {
        if (list == null) {
            throw new IllegalArgumentException("the list cannot be null");
        }
        return new AsList(list);
    }

    public static final <A extends Allele> AlleleList<A> emptyList() {
        return EMPTY_LIST;
    }

    public static <A extends Allele> AlleleListPermutation<A> permutation(AlleleList<A> original, AlleleList<A> target) {
        if (AlleleListUtils.equals(original, target)) {
            return new NonPermutation<A>(original);
        }
        return new ActualPermutation(original, target);
    }

    private static class ActualPermutation<A extends Allele>
    implements AlleleListPermutation<A> {
        private final AlleleList<A> from;
        private final AlleleList<A> to;
        private final int[] fromIndex;
        private final boolean nonPermuted;
        private final boolean isPartial;

        private ActualPermutation(AlleleList<A> original, AlleleList<A> target) {
            this.from = original;
            this.to = target;
            int toSize = target.alleleCount();
            int fromSize = original.alleleCount();
            if (fromSize < toSize) {
                throw new IllegalArgumentException("target allele list is not a permutation of the original allele list");
            }
            this.fromIndex = new int[toSize];
            boolean nonPermuted = fromSize == toSize;
            this.isPartial = !nonPermuted;
            for (int i = 0; i < toSize; ++i) {
                int originalIndex = original.alleleIndex(target.alleleAt(i));
                if (originalIndex < 0) {
                    throw new IllegalArgumentException("target allele list is not a permutation of the original allele list");
                }
                this.fromIndex[i] = originalIndex;
                nonPermuted &= originalIndex == i;
            }
            this.nonPermuted = nonPermuted;
        }

        @Override
        public boolean isPartial() {
            return this.isPartial;
        }

        @Override
        public boolean isNonPermuted() {
            return this.nonPermuted;
        }

        @Override
        public int toIndex(int fromIndex) {
            return this.to.alleleIndex(this.from.alleleAt(fromIndex));
        }

        @Override
        public int fromIndex(int toIndex) {
            return this.fromIndex[toIndex];
        }

        @Override
        public int fromSize() {
            return this.from.alleleCount();
        }

        @Override
        public int toSize() {
            return this.to.alleleCount();
        }

        @Override
        public List<A> fromList() {
            return AlleleListUtils.asList(this.from);
        }

        @Override
        public List<A> toList() {
            return AlleleListUtils.asList(this.to);
        }

        @Override
        public int alleleCount() {
            return this.to.alleleCount();
        }

        @Override
        public int alleleIndex(A allele) {
            return this.to.alleleIndex(allele);
        }

        @Override
        public A alleleAt(int index) {
            return this.to.alleleAt(index);
        }
    }

    private static class NonPermutation<A extends Allele>
    implements AlleleListPermutation<A> {
        private final AlleleList<A> list;

        public NonPermutation(AlleleList<A> original) {
            this.list = original;
        }

        @Override
        public boolean isPartial() {
            return false;
        }

        @Override
        public boolean isNonPermuted() {
            return true;
        }

        @Override
        public int toIndex(int fromIndex) {
            return fromIndex;
        }

        @Override
        public int fromIndex(int toIndex) {
            return toIndex;
        }

        @Override
        public int fromSize() {
            return this.list.alleleCount();
        }

        @Override
        public int toSize() {
            return this.list.alleleCount();
        }

        @Override
        public List<A> fromList() {
            return AlleleListUtils.asList(this.list);
        }

        @Override
        public List<A> toList() {
            return AlleleListUtils.asList(this.list);
        }

        @Override
        public int alleleCount() {
            return this.list.alleleCount();
        }

        @Override
        public int alleleIndex(A allele) {
            return this.list.alleleIndex(allele);
        }

        @Override
        public A alleleAt(int index) {
            return this.list.alleleAt(index);
        }
    }

    private static class AsList<A extends Allele>
    extends AbstractList<A> {
        private final AlleleList<A> list;

        private AsList(AlleleList<A> list) {
            this.list = list;
        }

        @Override
        public A get(int index) {
            return this.list.alleleAt(index);
        }

        @Override
        public int size() {
            return this.list.alleleCount();
        }
    }
}

