/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.gatk.utils.downsampling.ReservoirDownsampler;

public class SimplePositionalDownsampler<T extends SAMRecord>
extends ReadsDownsampler<T> {
    private final int targetCoverage;
    private final ReservoirDownsampler<T> reservoir;
    private int currentContigIndex;
    private int currentAlignmentStart;
    private boolean positionEstablished;
    private boolean unmappedReadsReached;
    private ArrayList<T> finalizedReads;

    public SimplePositionalDownsampler(int targetCoverage) {
        this.targetCoverage = targetCoverage;
        this.reservoir = new ReservoirDownsampler(targetCoverage);
        this.finalizedReads = new ArrayList();
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(T newRead) {
        this.updatePositionalState(newRead);
        if (this.unmappedReadsReached) {
            this.finalizedReads.add(newRead);
        } else {
            int reservoirPreviouslyDiscardedItems = this.reservoir.getNumberOfDiscardedItems();
            this.reservoir.submit(newRead);
            this.numDiscardedItems += this.reservoir.getNumberOfDiscardedItems() - reservoirPreviouslyDiscardedItems;
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.finalizedReads.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        ArrayList<T> toReturn = this.finalizedReads;
        this.finalizedReads = new ArrayList();
        return toReturn;
    }

    @Override
    public boolean hasPendingItems() {
        return this.reservoir.hasFinalizedItems();
    }

    @Override
    public T peekFinalized() {
        return (T)(this.finalizedReads.isEmpty() ? null : (SAMRecord)this.finalizedReads.get(0));
    }

    @Override
    public T peekPending() {
        return (T)this.reservoir.peekFinalized();
    }

    @Override
    public int size() {
        return this.finalizedReads.size() + this.reservoir.size();
    }

    @Override
    public void signalEndOfInput() {
        this.finalizeReservoir();
    }

    @Override
    public void clearItems() {
        this.reservoir.clearItems();
        this.reservoir.resetStats();
        this.finalizedReads.clear();
        this.positionEstablished = false;
        this.unmappedReadsReached = false;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return true;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
        this.updatePositionalState(read);
    }

    private void updatePositionalState(T newRead) {
        if (this.readIsPastCurrentPosition(newRead)) {
            if (this.reservoir.hasFinalizedItems()) {
                this.finalizeReservoir();
            }
            this.setCurrentPosition(newRead);
            if (((SAMRecord)newRead).getReadUnmappedFlag()) {
                this.unmappedReadsReached = true;
            }
        }
    }

    private void setCurrentPosition(T read) {
        this.currentContigIndex = ((SAMRecord)read).getReferenceIndex();
        this.currentAlignmentStart = ((SAMRecord)read).getAlignmentStart();
        this.positionEstablished = true;
    }

    private boolean readIsPastCurrentPosition(T read) {
        return !this.positionEstablished || ((SAMRecord)read).getReferenceIndex() > this.currentContigIndex || ((SAMRecord)read).getAlignmentStart() > this.currentAlignmentStart || ((SAMRecord)read).getReadUnmappedFlag() && !this.unmappedReadsReached;
    }

    private void finalizeReservoir() {
        this.finalizedReads.addAll(this.reservoir.consumeFinalizedItems());
        this.reservoir.resetStats();
    }
}

