/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class ReservoirDownsampler<T extends SAMRecord>
extends ReadsDownsampler<T> {
    private final int targetSampleSize;
    private final boolean expectFewOverflows;
    private List<T> reservoir;
    private List<T> undiscardableItems;
    private boolean isLinkedList;
    private int totalDiscardableReadsSeen;

    public ReservoirDownsampler(int targetSampleSize, boolean expectFewOverflows) {
        if (targetSampleSize <= 0) {
            throw new ReviewedGATKException("Cannot do reservoir downsampling with a sample size <= 0");
        }
        this.targetSampleSize = targetSampleSize;
        this.expectFewOverflows = expectFewOverflows;
        this.clearItems();
        this.resetStats();
    }

    public ReservoirDownsampler(int targetSampleSize) {
        this(targetSampleSize, false);
    }

    @Override
    public void submit(T newRead) {
        if (this.doNotDiscardItem(newRead)) {
            this.undiscardableItems.add(newRead);
            return;
        }
        ++this.totalDiscardableReadsSeen;
        if (this.totalDiscardableReadsSeen <= this.targetSampleSize) {
            this.reservoir.add(newRead);
        } else {
            int randomSlot;
            if (this.isLinkedList) {
                this.reservoir = new ArrayList<T>(this.reservoir);
                this.isLinkedList = false;
            }
            if ((randomSlot = Utils.getRandomGenerator().nextInt(this.totalDiscardableReadsSeen)) < this.targetSampleSize) {
                this.reservoir.set(randomSlot, newRead);
            }
            ++this.numDiscardedItems;
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.reservoir.isEmpty() || !this.undiscardableItems.isEmpty();
    }

    @Override
    public List<T> consumeFinalizedItems() {
        if (!this.hasFinalizedItems()) {
            return Collections.emptyList();
        }
        List<T> downsampledItems = this.reservoir;
        downsampledItems.addAll(this.undiscardableItems);
        this.clearItems();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(!this.reservoir.isEmpty() ? (SAMRecord)this.reservoir.get(0) : (!this.undiscardableItems.isEmpty() ? (SAMRecord)this.undiscardableItems.get(0) : null));
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int size() {
        return this.reservoir.size() + this.undiscardableItems.size();
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clearItems() {
        this.reservoir = this.expectFewOverflows ? new LinkedList() : new ArrayList(this.targetSampleSize);
        this.undiscardableItems = new LinkedList<T>();
        this.isLinkedList = this.expectFewOverflows;
        this.totalDiscardableReadsSeen = 0;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

