/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsamplerFactory;
import org.broadinstitute.gatk.utils.iterators.GATKSAMIterator;

public class PerSampleDownsamplingReadsIterator
implements GATKSAMIterator {
    private GATKSAMIterator nestedSAMIterator;
    private ReadsDownsamplerFactory<SAMRecord> downsamplerFactory;
    private Map<String, ReadsDownsampler<SAMRecord>> perSampleDownsamplers;
    private PriorityQueue<SAMRecord> orderedDownsampledReadsCache;
    private SAMRecord nextRead = null;
    private SAMRecordComparator readComparator = new SAMRecordCoordinateComparator();
    private SAMRecord earliestPendingRead = null;
    private ReadsDownsampler<SAMRecord> earliestPendingDownsampler = null;
    private static final int DOWNSAMPLED_READS_INITIAL_CACHE_SIZE = 4096;
    private static final int DOWNSAMPLER_POSITIONAL_UPDATE_INTERVAL = 3;

    public PerSampleDownsamplingReadsIterator(GATKSAMIterator iter, ReadsDownsamplerFactory<SAMRecord> downsamplerFactory) {
        this.nestedSAMIterator = iter;
        this.downsamplerFactory = downsamplerFactory;
        this.perSampleDownsamplers = new HashMap<String, ReadsDownsampler<SAMRecord>>();
        this.orderedDownsampledReadsCache = new PriorityQueue<SAMRecord>(4096, this.readComparator);
        this.advanceToNextRead();
    }

    @Override
    public boolean hasNext() {
        return this.nextRead != null;
    }

    @Override
    public SAMRecord next() {
        if (this.nextRead == null) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        SAMRecord toReturn = this.nextRead;
        this.advanceToNextRead();
        return toReturn;
    }

    private void advanceToNextRead() {
        this.nextRead = !this.readyToReleaseReads() && !this.fillDownsampledReadsCache() ? null : this.orderedDownsampledReadsCache.poll();
    }

    private boolean readyToReleaseReads() {
        if (this.orderedDownsampledReadsCache.isEmpty()) {
            return false;
        }
        return this.earliestPendingRead == null || this.readComparator.compare(this.orderedDownsampledReadsCache.peek(), this.earliestPendingRead) <= 0;
    }

    private boolean fillDownsampledReadsCache() {
        SAMRecord prevRead = null;
        int numPositionalChanges = 0;
        while (this.nestedSAMIterator.hasNext() && !this.readyToReleaseReads()) {
            SAMRecord read = (SAMRecord)this.nestedSAMIterator.next();
            String sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
            ReadsDownsampler<SAMRecord> thisSampleDownsampler = this.perSampleDownsamplers.get(sampleName);
            if (thisSampleDownsampler == null) {
                thisSampleDownsampler = this.downsamplerFactory.newInstance();
                this.perSampleDownsamplers.put(sampleName, thisSampleDownsampler);
            }
            thisSampleDownsampler.submit(read);
            this.processFinalizedAndPendingItems(thisSampleDownsampler);
            if (prevRead != null && prevRead.getAlignmentStart() != read.getAlignmentStart()) {
                ++numPositionalChanges;
            }
            if (numPositionalChanges > 0 && numPositionalChanges % 3 == 0) {
                for (ReadsDownsampler<SAMRecord> perSampleDownsampler : this.perSampleDownsamplers.values()) {
                    perSampleDownsampler.signalNoMoreReadsBefore(read);
                    this.processFinalizedAndPendingItems(perSampleDownsampler);
                }
            }
            prevRead = read;
        }
        if (!this.nestedSAMIterator.hasNext()) {
            for (ReadsDownsampler<SAMRecord> perSampleDownsampler : this.perSampleDownsamplers.values()) {
                perSampleDownsampler.signalEndOfInput();
                if (!perSampleDownsampler.hasFinalizedItems()) continue;
                this.orderedDownsampledReadsCache.addAll(perSampleDownsampler.consumeFinalizedItems());
            }
            this.earliestPendingRead = null;
            this.earliestPendingDownsampler = null;
        }
        return this.readyToReleaseReads();
    }

    private void updateEarliestPendingRead(ReadsDownsampler<SAMRecord> currentDownsampler) {
        if (this.earliestPendingRead == null && currentDownsampler.hasPendingItems()) {
            this.earliestPendingRead = (SAMRecord)currentDownsampler.peekPending();
            this.earliestPendingDownsampler = currentDownsampler;
        } else if (!(currentDownsampler != this.earliestPendingDownsampler || currentDownsampler.hasPendingItems() && this.readComparator.compare(currentDownsampler.peekPending(), this.earliestPendingRead) == 0)) {
            this.earliestPendingRead = null;
            this.earliestPendingDownsampler = null;
            for (ReadsDownsampler<SAMRecord> perSampleDownsampler : this.perSampleDownsamplers.values()) {
                if (!perSampleDownsampler.hasPendingItems() || this.earliestPendingRead != null && this.readComparator.compare(perSampleDownsampler.peekPending(), this.earliestPendingRead) >= 0) continue;
                this.earliestPendingRead = (SAMRecord)perSampleDownsampler.peekPending();
                this.earliestPendingDownsampler = perSampleDownsampler;
            }
        }
    }

    private void processFinalizedAndPendingItems(ReadsDownsampler<SAMRecord> currentDownsampler) {
        if (currentDownsampler.hasFinalizedItems()) {
            this.orderedDownsampledReadsCache.addAll(currentDownsampler.consumeFinalizedItems());
        }
        this.updateEarliestPendingRead(currentDownsampler);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.nestedSAMIterator.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

