/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;

public class PassThroughDownsampler<T extends SAMRecord>
extends ReadsDownsampler<T> {
    private LinkedList<T> selectedReads;

    public PassThroughDownsampler() {
        this.clearItems();
    }

    @Override
    public void submit(T newRead) {
        this.selectedReads.add(newRead);
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.selectedReads.isEmpty();
    }

    @Override
    public List<T> consumeFinalizedItems() {
        LinkedList<T> downsampledItems = this.selectedReads;
        this.clearItems();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.selectedReads.isEmpty() ? null : (SAMRecord)this.selectedReads.getFirst());
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int size() {
        return this.selectedReads.size();
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clearItems() {
        this.selectedReads = new LinkedList();
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

