/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.downsampling.Downsampler;

public class LevelingDownsampler<T extends List<E>, E>
extends Downsampler<T> {
    private final int minElementsPerStack;
    private final int targetSize;
    private List<T> groups;
    private boolean groupsAreFinalized;

    public LevelingDownsampler(int targetSize) {
        this(targetSize, 1);
    }

    public LevelingDownsampler(int targetSize, int minElementsPerStack) {
        if (targetSize < 0) {
            throw new IllegalArgumentException("targetSize must be >= 0 but got " + targetSize);
        }
        if (minElementsPerStack < 0) {
            throw new IllegalArgumentException("minElementsPerStack must be >= 0 but got " + minElementsPerStack);
        }
        this.targetSize = targetSize;
        this.minElementsPerStack = minElementsPerStack;
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(T item) {
        this.groups.add(item);
    }

    @Override
    public void submit(Collection<T> items) {
        this.groups.addAll(items);
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.groupsAreFinalized && this.groups.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        if (!this.hasFinalizedItems()) {
            return new ArrayList();
        }
        List<T> toReturn = this.groups;
        this.clearItems();
        return toReturn;
    }

    @Override
    public boolean hasPendingItems() {
        return !this.groupsAreFinalized && this.groups.size() > 0;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.hasFinalizedItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public T peekPending() {
        return (T)(this.hasPendingItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public int size() {
        int s = 0;
        for (List l : this.groups) {
            s += l.size();
        }
        return s;
    }

    @Override
    public void signalEndOfInput() {
        this.levelGroups();
        this.groupsAreFinalized = true;
    }

    @Override
    public void clearItems() {
        this.groups = new ArrayList<T>();
        this.groupsAreFinalized = false;
    }

    private void levelGroups() {
        int[] groupSizes = new int[this.groups.size()];
        int totalSize = 0;
        int currentGroupIndex = 0;
        for (List group : this.groups) {
            groupSizes[currentGroupIndex] = group.size();
            totalSize += groupSizes[currentGroupIndex];
            ++currentGroupIndex;
        }
        if (totalSize <= this.targetSize) {
            return;
        }
        int numItemsToRemove = totalSize - this.targetSize;
        currentGroupIndex = 0;
        int numConsecutiveUmodifiableGroups = 0;
        while (numItemsToRemove > 0 && numConsecutiveUmodifiableGroups < groupSizes.length) {
            if (groupSizes[currentGroupIndex] > this.minElementsPerStack) {
                int n = currentGroupIndex;
                groupSizes[n] = groupSizes[n] - 1;
                --numItemsToRemove;
                numConsecutiveUmodifiableGroups = 0;
            } else {
                ++numConsecutiveUmodifiableGroups;
            }
            currentGroupIndex = (currentGroupIndex + 1) % groupSizes.length;
        }
        currentGroupIndex = 0;
        for (List group : this.groups) {
            this.downsampleOneGroup(group, groupSizes[currentGroupIndex]);
            ++currentGroupIndex;
        }
    }

    private void downsampleOneGroup(T group, int numItemsToKeep) {
        if (numItemsToKeep >= group.size()) {
            return;
        }
        BitSet itemsToKeep = new BitSet(group.size());
        for (Integer selectedIndex : MathUtils.sampleIndicesWithoutReplacement(group.size(), numItemsToKeep)) {
            itemsToKeep.set(selectedIndex);
        }
        int currentIndex = 0;
        if (group instanceof LinkedList) {
            Iterator iter = group.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!itemsToKeep.get(currentIndex) && !this.doNotDiscardItem(item)) {
                    iter.remove();
                    ++this.numDiscardedItems;
                }
                ++currentIndex;
            }
        } else {
            ArrayList keptItems = new ArrayList(group.size());
            for (Object item : group) {
                if (itemsToKeep.get(currentIndex) || this.doNotDiscardItem(item)) {
                    keptItems.add(item);
                }
                ++currentIndex;
            }
            this.numDiscardedItems += group.size() - keptItems.size();
            group.clear();
            group.addAll(keptItems);
        }
    }
}

