/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class FractionalDownsampler<T extends SAMRecord>
extends ReadsDownsampler<T> {
    private ArrayList<T> selectedReads;
    private final int cutoffForInclusion;
    private static final int RANDOM_POOL_SIZE = 10000;

    public FractionalDownsampler(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new ReviewedGATKException("Fraction of reads to include must be between 0.0 and 1.0, inclusive");
        }
        this.cutoffForInclusion = (int)(fraction * 10000.0);
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(T newRead) {
        if (Utils.getRandomGenerator().nextInt(10000) < this.cutoffForInclusion || this.doNotDiscardItem(newRead)) {
            this.selectedReads.add(newRead);
        } else {
            ++this.numDiscardedItems;
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.selectedReads.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        ArrayList<T> downsampledItems = this.selectedReads;
        this.clearItems();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.selectedReads.isEmpty() ? null : (SAMRecord)this.selectedReads.get(0));
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int size() {
        return this.selectedReads.size();
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clearItems() {
        this.selectedReads = new ArrayList();
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

