/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.downsampling.LevelingDownsampler;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public class DownsamplingUtils {
    private DownsamplingUtils() {
    }

    public static List<GATKSAMRecord> levelCoverageByPosition(List<GATKSAMRecord> reads, int downsampleTo, int minReadsPerAlignmentStart) {
        if (reads == null) {
            throw new IllegalArgumentException("reads must not be null");
        }
        ArrayList<GATKSAMRecord> downsampled = new ArrayList<GATKSAMRecord>(reads.size());
        Map<String, Map<Integer, List<GATKSAMRecord>>> readsBySampleByStart = DownsamplingUtils.partitionReadsBySampleAndStart(reads);
        for (Map<Integer, List<GATKSAMRecord>> readsByPosMap : readsBySampleByStart.values()) {
            LevelingDownsampler downsampler = new LevelingDownsampler(downsampleTo, minReadsPerAlignmentStart);
            downsampler.submit(readsByPosMap.values());
            downsampler.signalEndOfInput();
            for (List downsampledReads : downsampler.consumeFinalizedItems()) {
                downsampled.addAll(downsampledReads);
            }
        }
        return ReadUtils.sortReadsByCoordinate(downsampled);
    }

    private static Map<String, Map<Integer, List<GATKSAMRecord>>> partitionReadsBySampleAndStart(List<GATKSAMRecord> reads) {
        LinkedHashMap<String, Map<Integer, List<GATKSAMRecord>>> readsBySampleByStart = new LinkedHashMap<String, Map<Integer, List<GATKSAMRecord>>>();
        for (GATKSAMRecord read : reads) {
            LinkedList<GATKSAMRecord> readsAtStart;
            LinkedHashMap<Integer, LinkedList<GATKSAMRecord>> readsByStart = (LinkedHashMap<Integer, LinkedList<GATKSAMRecord>>)readsBySampleByStart.get(read.getReadGroup().getSample());
            if (readsByStart == null) {
                readsByStart = new LinkedHashMap<Integer, LinkedList<GATKSAMRecord>>();
                readsBySampleByStart.put(read.getReadGroup().getSample(), readsByStart);
            }
            if ((readsAtStart = (LinkedList<GATKSAMRecord>)readsByStart.get(read.getAlignmentStart())) == null) {
                readsAtStart = new LinkedList<GATKSAMRecord>();
                readsByStart.put(read.getAlignmentStart(), readsAtStart);
            }
            readsAtStart.add(read);
        }
        return readsBySampleByStart;
    }
}

