/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import htsjdk.samtools.SAMRecord;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.gatk.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.gatk.utils.iterators.GATKSAMIterator;

public class DownsamplingReadsIterator
implements GATKSAMIterator {
    private GATKSAMIterator nestedSAMIterator;
    private ReadsDownsampler<SAMRecord> downsampler;
    private Collection<SAMRecord> downsampledReadsCache;
    private SAMRecord nextRead = null;
    private Iterator<SAMRecord> downsampledReadsCacheIterator = null;

    public DownsamplingReadsIterator(GATKSAMIterator iter, ReadsDownsampler<SAMRecord> downsampler) {
        this.nestedSAMIterator = iter;
        this.downsampler = downsampler;
        this.advanceToNextRead();
    }

    @Override
    public boolean hasNext() {
        return this.nextRead != null;
    }

    @Override
    public SAMRecord next() {
        if (this.nextRead == null) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        SAMRecord toReturn = this.nextRead;
        this.advanceToNextRead();
        return toReturn;
    }

    private void advanceToNextRead() {
        this.nextRead = !this.readyToReleaseReads() && !this.fillDownsampledReadsCache() ? null : this.downsampledReadsCacheIterator.next();
    }

    private boolean readyToReleaseReads() {
        return this.downsampledReadsCacheIterator != null && this.downsampledReadsCacheIterator.hasNext();
    }

    private boolean fillDownsampledReadsCache() {
        while (this.nestedSAMIterator.hasNext() && !this.downsampler.hasFinalizedItems()) {
            this.downsampler.submit((SAMRecord)this.nestedSAMIterator.next());
        }
        if (!this.nestedSAMIterator.hasNext()) {
            this.downsampler.signalEndOfInput();
        }
        this.downsampledReadsCache = this.downsampler.consumeFinalizedItems();
        this.downsampledReadsCacheIterator = this.downsampledReadsCache.iterator();
        return this.downsampledReadsCacheIterator.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.nestedSAMIterator.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

