/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.downsampling;

import java.util.Collection;
import java.util.List;

public abstract class Downsampler<T> {
    protected int numDiscardedItems = 0;

    public abstract void submit(T var1);

    public void submit(Collection<T> items) {
        if (items == null) {
            throw new IllegalArgumentException("submitted items must not be null");
        }
        for (T item : items) {
            this.submit(item);
        }
    }

    public abstract boolean hasFinalizedItems();

    public abstract List<T> consumeFinalizedItems();

    public abstract boolean hasPendingItems();

    public abstract T peekFinalized();

    public abstract T peekPending();

    public abstract int size();

    public int getNumberOfDiscardedItems() {
        return this.numDiscardedItems;
    }

    public abstract void signalEndOfInput();

    public abstract void clearItems();

    public void resetStats() {
        this.numDiscardedItems = 0;
    }

    protected boolean doNotDiscardItem(Object item) {
        return false;
    }
}

