/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.diffengine;

import org.broadinstitute.gatk.utils.diffengine.DiffElement;
import org.broadinstitute.gatk.utils.diffengine.DiffEngine;

public class Difference
implements Comparable<Difference> {
    final String path;
    final String[] parts;
    int count = 1;
    DiffElement master = null;
    DiffElement test = null;

    public Difference(String path) {
        this.path = path;
        this.parts = DiffEngine.diffNameToPath(path);
    }

    public Difference(DiffElement master, DiffElement test) {
        this(Difference.createPath(master, test), master, test);
    }

    public Difference(String path, DiffElement master, DiffElement test) {
        this(path);
        this.master = master;
        this.test = test;
    }

    public String[] getParts() {
        return this.parts;
    }

    public void incCount() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getPath() {
        return this.path;
    }

    public int length() {
        return this.parts.length;
    }

    public boolean matches(String[] otherParts) {
        if (otherParts.length != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            String part = this.parts[i];
            if (part.equals("*") || part.equals(otherParts[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s:%d:%s", this.getPath(), this.getCount(), this.valueDiffString());
    }

    @Override
    public int compareTo(Difference other) {
        int countCmp = Integer.valueOf(this.count).compareTo(other.count);
        return countCmp != 0 ? -1 * countCmp : this.path.compareTo(other.path);
    }

    public String valueDiffString() {
        if (this.hasSpecificDifference()) {
            return String.format("%s!=%s", Difference.getOneLineString(this.master), Difference.getOneLineString(this.test));
        }
        return "N/A";
    }

    private static String createPath(DiffElement master, DiffElement test) {
        return (master == null ? test : master).fullyQualifiedName();
    }

    private static String getOneLineString(DiffElement elt) {
        return elt == null ? "MISSING" : elt.getValue().toOneLineString();
    }

    public boolean hasSpecificDifference() {
        return this.master != null || this.test != null;
    }

    public DiffElement getMaster() {
        return this.master;
    }

    public DiffElement getTest() {
        return this.test;
    }
}

