/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.diffengine;

import htsjdk.samtools.FileTruncatedException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.broadinstitute.gatk.utils.diffengine.DiffElement;
import org.broadinstitute.gatk.utils.diffengine.DiffNode;
import org.broadinstitute.gatk.utils.diffengine.DiffableReader;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class BAMDiffableReader
implements DiffableReader {
    @Override
    public String getName() {
        return "BAM";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(file);
        DiffNode root = DiffNode.rooted(file.getName());
        SAMRecordIterator iterator = reader.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            SAMRecord record = (SAMRecord)iterator.next();
            String name = record.getReadName().replace('.', '_');
            if (record.getReadPairedFlag()) {
                name = name + (record.getFirstOfPairFlag() ? "_1" : "_2");
            }
            DiffNode readRoot = DiffNode.empty(name, root);
            readRoot.add("NAME", record.getReadName());
            readRoot.add("FLAGS", record.getFlags());
            readRoot.add("RNAME", record.getReferenceName());
            readRoot.add("POS", record.getAlignmentStart());
            readRoot.add("MAPQ", record.getMappingQuality());
            readRoot.add("CIGAR", record.getCigarString());
            readRoot.add("RNEXT", record.getMateReferenceName());
            readRoot.add("PNEXT", record.getMateAlignmentStart());
            readRoot.add("TLEN", record.getInferredInsertSize());
            readRoot.add("SEQ", record.getReadString());
            readRoot.add("QUAL", record.getBaseQualityString());
            for (SAMRecord.SAMTagAndValue xt : record.getAttributes()) {
                readRoot.add(xt.tag, xt.value);
            }
            if (!root.hasElement(name)) {
                root.add(readRoot);
            }
            if ((count += readRoot.size()) <= maxElementsToRead || maxElementsToRead == -1) continue;
            break;
        }
        try {
            reader.close();
        }
        catch (IOException ex) {
            throw new ReviewedGATKException("Unable to close " + file, ex);
        }
        return root.getBinding();
    }

    @Override
    public boolean canRead(File file) {
        byte[] BAM_MAGIC = "BAM\u0001".getBytes();
        byte[] buffer = new byte[BAM_MAGIC.length];
        try {
            BufferedInputStream fstream = new BufferedInputStream(new FileInputStream(file));
            if (!BlockCompressedInputStream.isValidFile(fstream)) {
                return false;
            }
            BlockCompressedInputStream BCIS = new BlockCompressedInputStream(fstream);
            BCIS.read(buffer, 0, BAM_MAGIC.length);
            BCIS.close();
            return Arrays.equals(buffer, BAM_MAGIC);
        }
        catch (IOException e) {
            return false;
        }
        catch (FileTruncatedException e) {
            return false;
        }
    }
}

