/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.contexts;

import java.util.List;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.HasGenomeLocation;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileup;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class AlignmentContext
implements HasGenomeLocation {
    protected GenomeLoc loc = null;
    protected ReadBackedPileup basePileup = null;
    protected boolean hasPileupBeenDownsampled;
    private long skippedBases = 0L;

    public AlignmentContext(GenomeLoc loc, ReadBackedPileup basePileup) {
        this(loc, basePileup, 0L, false);
    }

    public AlignmentContext(GenomeLoc loc, ReadBackedPileup basePileup, boolean hasPileupBeenDownsampled) {
        this(loc, basePileup, 0L, hasPileupBeenDownsampled);
    }

    public AlignmentContext(GenomeLoc loc, ReadBackedPileup basePileup, long skippedBases) {
        this(loc, basePileup, skippedBases, false);
    }

    public AlignmentContext(GenomeLoc loc, ReadBackedPileup basePileup, long skippedBases, boolean hasPileupBeenDownsampled) {
        if (loc == null) {
            throw new ReviewedGATKException("BUG: GenomeLoc in Alignment context is null");
        }
        if (basePileup == null) {
            throw new ReviewedGATKException("BUG: ReadBackedPileup in Alignment context is null");
        }
        if (skippedBases < 0L) {
            throw new ReviewedGATKException("BUG: skippedBases is -1 in Alignment context");
        }
        this.loc = loc;
        this.basePileup = basePileup;
        this.skippedBases = skippedBases;
        this.hasPileupBeenDownsampled = hasPileupBeenDownsampled;
    }

    @Deprecated
    public ReadBackedPileup getPileup() {
        return this.basePileup;
    }

    public ReadBackedPileup getBasePileup() {
        return this.basePileup;
    }

    public boolean hasPileupBeenDownsampled() {
        return this.hasPileupBeenDownsampled;
    }

    @Deprecated
    public List<GATKSAMRecord> getReads() {
        return this.basePileup.getReads();
    }

    public boolean hasReads() {
        return this.basePileup != null && this.basePileup.getNumberOfElements() > 0;
    }

    public int size() {
        return this.basePileup.getNumberOfElements();
    }

    @Deprecated
    public List<Integer> getOffsets() {
        return this.basePileup.getOffsets();
    }

    public String getContig() {
        return this.getLocation().getContig();
    }

    public long getPosition() {
        return this.getLocation().getStart();
    }

    @Override
    public GenomeLoc getLocation() {
        return this.loc;
    }

    public void downsampleToCoverage(int coverage) {
        this.basePileup = this.basePileup.getDownsampledPileup(coverage);
        this.hasPileupBeenDownsampled = true;
    }

    public long getSkippedBases() {
        return this.skippedBases;
    }
}

