/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import com.google.java.contract.Requires;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.classloader.PluginManager;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.ArgumentCollection;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinitionGroup;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinitions;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatch;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSite;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchStringValue;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchValue;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatches;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.ArgumentValueOutOfRangeException;
import org.broadinstitute.gatk.utils.commandline.ArgumentsAreMutuallyExclusiveException;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;
import org.broadinstitute.gatk.utils.commandline.CommandLineUtils;
import org.broadinstitute.gatk.utils.commandline.CompoundArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.DefinitionMatcher;
import org.broadinstitute.gatk.utils.commandline.IntervalBindingArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.InvalidArgumentException;
import org.broadinstitute.gatk.utils.commandline.InvalidArgumentValueException;
import org.broadinstitute.gatk.utils.commandline.MissingArgumentException;
import org.broadinstitute.gatk.utils.commandline.MultiplexArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.OtherRequiredArgumentMissingException;
import org.broadinstitute.gatk.utils.commandline.ParsedArgs;
import org.broadinstitute.gatk.utils.commandline.ParsedListArgs;
import org.broadinstitute.gatk.utils.commandline.ParsingEngineArgumentProvider;
import org.broadinstitute.gatk.utils.commandline.ParsingMethod;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.commandline.RodBindingArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.RodBindingCollectionArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.SimpleArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.commandline.TooManyValuesForArgumentException;
import org.broadinstitute.gatk.utils.commandline.UnmatchedArgumentException;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.help.ApplicationDetails;
import org.broadinstitute.gatk.utils.help.HelpFormatter;

public class ParsingEngine {
    private Map<ArgumentDefinition, ArgumentSource> argumentSourcesByDefinition = new HashMap<ArgumentDefinition, ArgumentSource>();
    public ArgumentDefinitions argumentDefinitions = new ArgumentDefinitions();
    private ArgumentMatches argumentMatches = null;
    private List<ParsingMethod> parsingMethods = new ArrayList<ParsingMethod>();
    private List<RodBinding> rodBindings = new ArrayList<RodBinding>();
    private static final Set<ArgumentTypeDescriptor> STANDARD_ARGUMENT_TYPE_DESCRIPTORS = new LinkedHashSet<ArgumentTypeDescriptor>(Arrays.asList(new SimpleArgumentTypeDescriptor(), new IntervalBindingArgumentTypeDescriptor(), new RodBindingArgumentTypeDescriptor(), new RodBindingCollectionArgumentTypeDescriptor(), new CompoundArgumentTypeDescriptor(), new MultiplexArgumentTypeDescriptor()));
    private Set<ArgumentTypeDescriptor> argumentTypeDescriptors = new LinkedHashSet<ArgumentTypeDescriptor>();
    private final Map<Object, Tags> tags = new IdentityHashMap<Object, Tags>();
    private PluginManager<ParsingEngineArgumentProvider> argumentProviderPluginManager = new PluginManager(ParsingEngineArgumentProvider.class);
    protected static Logger logger = Logger.getLogger(ParsingEngine.class);

    public ParsingEngine(CommandLineProgram clp) {
        RodBinding.resetNameCounter();
        this.parsingMethods.add(ParsingMethod.FullNameParsingMethod);
        this.parsingMethods.add(ParsingMethod.ShortNameParsingMethod);
        if (clp != null) {
            this.argumentTypeDescriptors.addAll(clp.getArgumentTypeDescriptors());
        }
        this.argumentTypeDescriptors.addAll(STANDARD_ARGUMENT_TYPE_DESCRIPTORS);
        List<Class<ParsingEngineArgumentProvider>> providers = this.argumentProviderPluginManager.getPlugins();
        for (Class<ParsingEngineArgumentProvider> provider : providers) {
            this.addArgumentSource(provider);
        }
    }

    public void addArgumentSource(Class source) {
        this.addArgumentSource(null, source);
    }

    public ArgumentMatches getArgumentMatches() {
        return this.argumentMatches;
    }

    public void addArgumentSource(String sourceName, Class sourceClass) {
        ArrayList<ArgumentDefinition> argumentsFromSource = new ArrayList<ArgumentDefinition>();
        for (ArgumentSource argumentSource : this.extractArgumentSources(sourceClass)) {
            List<ArgumentDefinition> argumentDefinitions = argumentSource.createArgumentDefinitions();
            for (ArgumentDefinition argumentDefinition : argumentDefinitions) {
                this.argumentSourcesByDefinition.put(argumentDefinition, argumentSource);
                argumentsFromSource.add(argumentDefinition);
            }
        }
        this.argumentDefinitions.add(new ArgumentDefinitionGroup(sourceName, argumentsFromSource));
    }

    public boolean isArgumentPresent(String argumentFullName) {
        ArgumentDefinition definition = this.argumentDefinitions.findArgumentDefinition(argumentFullName, ArgumentDefinitions.FullNameDefinitionMatcher);
        return this.argumentMatches.hasMatch(definition);
    }

    public SortedMap<ArgumentMatchSource, ParsedArgs> parse(String[] tokens) {
        this.argumentMatches = new ArgumentMatches();
        TreeMap<ArgumentMatchSource, ParsedArgs> parsedArgs = new TreeMap<ArgumentMatchSource, ParsedArgs>();
        List<String> cmdLineTokens = Arrays.asList(tokens);
        this.parse(ArgumentMatchSource.COMMAND_LINE, cmdLineTokens, this.argumentMatches, parsedArgs);
        List<ParsingEngineArgumentProvider> providers = this.argumentProviderPluginManager.createAllTypes();
        for (ParsingEngineArgumentProvider provider : providers) {
            this.loadArgumentsIntoObject(provider);
        }
        for (ParsingEngineArgumentProvider provider : providers) {
            provider.parse(this, parsedArgs);
        }
        return parsedArgs;
    }

    public void parse(ArgumentMatchSource matchSource, List<String> tokens, ArgumentMatches argumentMatches, SortedMap<ArgumentMatchSource, ParsedArgs> parsedArgs) {
        ArgumentMatchSite lastArgumentMatchSite = new ArgumentMatchSite(matchSource, -1);
        int i = 0;
        for (String token : tokens) {
            ArgumentMatchSite site = new ArgumentMatchSite(matchSource, i);
            if (this.isArgumentForm(token)) {
                ArgumentMatch argumentMatch = this.parseArgument(token, site);
                if (argumentMatch != null) {
                    argumentMatches.mergeInto(argumentMatch);
                    lastArgumentMatchSite = site;
                }
            } else if (argumentMatches.hasMatch(lastArgumentMatchSite) && !argumentMatches.getMatch(lastArgumentMatchSite).hasValueAtSite(lastArgumentMatchSite)) {
                argumentMatches.getMatch(lastArgumentMatchSite).addValue(lastArgumentMatchSite, new ArgumentMatchStringValue(token));
            } else {
                argumentMatches.MissingArgument.addValue(site, new ArgumentMatchStringValue(token));
            }
            ++i;
        }
        parsedArgs.put(matchSource, new ParsedListArgs(tokens));
    }

    public void parsePairs(ArgumentMatchSource matchSource, List<Pair<String, ArgumentMatchValue>> tokens, ArgumentMatches argumentMatches, ParsedArgs matchSourceArgs, SortedMap<ArgumentMatchSource, ParsedArgs> parsedArgs) {
        int i = 0;
        for (Pair<String, ArgumentMatchValue> pair : tokens) {
            ArgumentMatchSite site = new ArgumentMatchSite(matchSource, i);
            List<DefinitionMatcher> matchers = Arrays.asList(ArgumentDefinitions.FullNameDefinitionMatcher, ArgumentDefinitions.ShortNameDefinitionMatcher);
            ArgumentDefinition definition = null;
            for (DefinitionMatcher matcher : matchers) {
                definition = this.argumentDefinitions.findArgumentDefinition(pair.getFirst(), matcher);
                if (definition == null) continue;
                break;
            }
            if (definition == null) continue;
            ArgumentMatch argumentMatch = new ArgumentMatch(pair.getFirst(), definition, site, new Tags());
            argumentMatches.mergeInto(argumentMatch);
            argumentMatch.addValue(site, pair.getSecond());
            ++i;
        }
        parsedArgs.put(matchSource, matchSourceArgs);
    }

    protected List<String> getArguments(File file) {
        try {
            if (file.getAbsolutePath().endsWith(".list")) {
                return this.getListArguments(file);
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(file, (Exception)e);
        }
        throw new UserException.CouldNotReadInputFile(file, "file extension is not .list");
    }

    private List<String> getListArguments(File file) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>();
        for (String line : FileUtils.readLines(file)) {
            argsList.addAll(Arrays.asList(Utils.escapeExpressions(line)));
        }
        return argsList;
    }

    public void validate() {
        this.validate(EnumSet.noneOf(ValidationType.class));
    }

    public void validate(EnumSet<ValidationType> skipValidationOf) {
        ArgumentMatches invalidArguments;
        if (!skipValidationOf.contains((Object)ValidationType.MissingRequiredArgument)) {
            Collection<ArgumentDefinition> requiredArguments = this.argumentDefinitions.findArgumentDefinitions(true, ArgumentDefinitions.RequiredDefinitionMatcher);
            ArrayList<ArgumentDefinition> missingArguments = new ArrayList<ArgumentDefinition>();
            for (ArgumentDefinition argumentDefinition : requiredArguments) {
                if (this.argumentMatches.hasMatch(argumentDefinition)) continue;
                missingArguments.add(argumentDefinition);
            }
            if (missingArguments.size() > 0) {
                throw new MissingArgumentException(missingArguments);
            }
        }
        if (!skipValidationOf.contains((Object)ValidationType.InvalidArgument) && (invalidArguments = this.argumentMatches.findUnmatched()).size() > 0) {
            throw new InvalidArgumentException(invalidArguments);
        }
        if (!skipValidationOf.contains((Object)ValidationType.InvalidArgumentValue)) {
            Collection<ArgumentDefinition> verifiableArguments = this.argumentDefinitions.findArgumentDefinitions(null, ArgumentDefinitions.VerifiableDefinitionMatcher);
            ArrayList<Pair<ArgumentDefinition, String>> invalidValues = new ArrayList<Pair<ArgumentDefinition, String>>();
            for (ArgumentDefinition argumentDefinition : verifiableArguments) {
                ArgumentMatches verifiableMatches = this.argumentMatches.findMatches(argumentDefinition);
                for (ArgumentMatch verifiableMatch : verifiableMatches) {
                    ArgumentSource argumentSource = this.argumentSourcesByDefinition.get(argumentDefinition);
                    if (verifiableMatch.values().size() != 0 || argumentDefinition.isFlag || argumentSource.createsTypeDefault()) continue;
                    invalidValues.add(new Pair<ArgumentDefinition, Object>(argumentDefinition, null));
                }
                for (ArgumentMatch verifiableMatch : verifiableMatches) {
                    for (ArgumentMatchValue value : verifiableMatch.values()) {
                        if (argumentDefinition.validation == null || value.asString().matches(argumentDefinition.validation)) continue;
                        invalidValues.add(new Pair<ArgumentDefinition, String>(argumentDefinition, value.asString()));
                    }
                }
            }
            if (invalidValues.size() > 0) {
                throw new InvalidArgumentValueException(invalidValues);
            }
        }
        if (!skipValidationOf.contains((Object)ValidationType.ValueMissingArgument) && this.argumentMatches.MissingArgument.values().size() > 0) {
            throw new UnmatchedArgumentException(this.argumentMatches.MissingArgument);
        }
        if (!skipValidationOf.contains((Object)ValidationType.TooManyValuesForArgument)) {
            ArrayList<ArgumentMatch> overvaluedArguments = new ArrayList<ArgumentMatch>();
            for (ArgumentMatch argumentMatch : this.argumentMatches.findSuccessfulMatches()) {
                if (argumentMatch.definition.isMultiValued || argumentMatch.values().size() <= 1) continue;
                overvaluedArguments.add(argumentMatch);
            }
            if (!overvaluedArguments.isEmpty()) {
                throw new TooManyValuesForArgumentException(overvaluedArguments);
            }
        }
        if (!skipValidationOf.contains((Object)ValidationType.MutuallyExclusive)) {
            ArrayList<Pair<ArgumentMatch, ArgumentMatch>> invalidPairs = new ArrayList<Pair<ArgumentMatch, ArgumentMatch>>();
            for (ArgumentMatch argumentMatch : this.argumentMatches.findSuccessfulMatches()) {
                if (argumentMatch.definition.exclusiveOf == null) continue;
                for (ArgumentMatch conflictingMatch : this.argumentMatches.findSuccessfulMatches()) {
                    if (argumentMatch == conflictingMatch || !argumentMatch.definition.exclusiveOf.equals(conflictingMatch.definition.fullName) && !argumentMatch.definition.exclusiveOf.equals(conflictingMatch.definition.shortName)) continue;
                    invalidPairs.add(new Pair<ArgumentMatch, ArgumentMatch>(argumentMatch, conflictingMatch));
                }
            }
            if (!invalidPairs.isEmpty()) {
                throw new ArgumentsAreMutuallyExclusiveException(invalidPairs);
            }
        }
        if (!skipValidationOf.contains((Object)ValidationType.OtherArgumentRequired)) {
            ArrayList<ArgumentMatch> missingRequiredPairs = new ArrayList<ArgumentMatch>();
            for (ArgumentMatch argumentMatch : this.argumentMatches.findSuccessfulMatches()) {
                if (argumentMatch.definition.otherArgumentRequired == null) continue;
                boolean bl = false;
                for (ArgumentMatch otherRequiredMatch : this.argumentMatches.findSuccessfulMatches()) {
                    if (!argumentMatch.definition.otherArgumentRequired.equals(otherRequiredMatch.label)) continue;
                    bl = true;
                }
                if (bl) continue;
                missingRequiredPairs.add(argumentMatch);
                throw new OtherRequiredArgumentMissingException(missingRequiredPairs);
            }
        }
    }

    public void loadArgumentsIntoObject(Object object) {
        this.loadArgumentsIntoObject(object, true);
    }

    public void loadArgumentsIntoObject(Object object, boolean enforceArgumentRanges) {
        List<ArgumentSource> argumentSources = this.extractArgumentSources(object.getClass());
        ArrayList<ArgumentSource> dependentArguments = new ArrayList<ArgumentSource>();
        for (ArgumentSource argumentSource : argumentSources) {
            if (argumentSource.isDeprecated() && this.argumentMatches.findMatches(this, argumentSource).size() > 0) {
                this.notifyDeprecatedCommandLineArgument(argumentSource);
            }
            if (argumentSource.isDependent()) {
                dependentArguments.add(argumentSource);
                continue;
            }
            this.loadValueIntoObject(argumentSource, object, this.argumentMatches.findMatches(this, argumentSource), enforceArgumentRanges);
        }
        for (ArgumentSource dependentArgument : dependentArguments) {
            MultiplexArgumentTypeDescriptor dependentDescriptor = dependentArgument.createDependentTypeDescriptor(this, object);
            ArgumentSource dependentSource = dependentArgument.copyWithCustomTypeDescriptor(dependentDescriptor);
            this.loadValueIntoObject(dependentSource, object, this.argumentMatches.findMatches(this, dependentSource), enforceArgumentRanges);
        }
    }

    public void addTags(Object key, Tags tags) {
        this.tags.put(key, tags);
    }

    public Tags getTags(Object key) {
        if (!this.tags.containsKey(key)) {
            return new Tags();
        }
        return this.tags.get(key);
    }

    @Requires(value={"rodBinding != null"})
    public void addRodBinding(RodBinding rodBinding) {
        this.rodBindings.add(rodBinding);
    }

    private void notifyDeprecatedCommandLineArgument(ArgumentSource argumentSource) {
        List<ArgumentDefinition> definitions = argumentSource.createArgumentDefinitions();
        if (definitions.size() < 1) {
            throw new ReviewedGATKException("Internal error.  Argument source creates no definitions.");
        }
        ArgumentDefinition definition = definitions.get(0);
        throw new UserException.DeprecatedArgument(definition.fullName, definition.doc);
    }

    private void loadValueIntoObject(ArgumentSource source, Object instance, ArgumentMatches argumentMatches, boolean enforceArgumentRanges) {
        if (argumentMatches.size() == 0 && !source.createsTypeDefault()) {
            return;
        }
        Collection<Object> targets = this.findTargets(source, instance);
        if (targets.size() == 0) {
            throw new ReviewedGATKException("Internal command-line parser error: unable to find a home for argument matches " + argumentMatches);
        }
        for (Object target : targets) {
            Object value;
            boolean usedTypeDefault = false;
            if (argumentMatches.size() != 0) {
                value = source.parse(this, argumentMatches);
            } else {
                value = source.createTypeDefault(this);
                usedTypeDefault = true;
            }
            if (enforceArgumentRanges && !usedTypeDefault) {
                this.checkArgumentRange(source, value);
            }
            JVMUtils.setFieldValue(source.field, target, value);
        }
    }

    private void checkArgumentRange(ArgumentSource argumentSource, Object argumentValue) {
        if (!(argumentValue instanceof Number)) {
            return;
        }
        double argumentDoubleValue = ((Number)argumentValue).doubleValue();
        Argument argumentAnnotation = argumentSource.field.getAnnotation(Argument.class);
        if (argumentAnnotation == null) {
            return;
        }
        double minValue = (Double)CommandLineUtils.getValue(argumentAnnotation, "minValue");
        double maxValue = (Double)CommandLineUtils.getValue(argumentAnnotation, "maxValue");
        double minRecommendedValue = (Double)CommandLineUtils.getValue(argumentAnnotation, "minRecommendedValue");
        double maxRecommendedValue = (Double)CommandLineUtils.getValue(argumentAnnotation, "maxRecommendedValue");
        String argumentName = (String)CommandLineUtils.getValue(argumentAnnotation, "fullName");
        if (minValue != Double.NEGATIVE_INFINITY && argumentDoubleValue < minValue) {
            throw new ArgumentValueOutOfRangeException(argumentName, argumentDoubleValue, minValue, "minimum");
        }
        if (maxValue != Double.POSITIVE_INFINITY && argumentDoubleValue > maxValue) {
            throw new ArgumentValueOutOfRangeException(argumentName, argumentDoubleValue, maxValue, "maximum");
        }
        if (minRecommendedValue != Double.NEGATIVE_INFINITY && argumentDoubleValue < minRecommendedValue) {
            logger.warn(String.format("WARNING: argument --%s has value %.2f, but minimum recommended value is %.2f", argumentName, argumentDoubleValue, minRecommendedValue));
        }
        if (maxRecommendedValue != Double.POSITIVE_INFINITY && argumentDoubleValue > maxRecommendedValue) {
            logger.warn(String.format("WARNING: argument --%s has value %.2f, but maximum recommended value is %.2f", argumentName, argumentDoubleValue, maxRecommendedValue));
        }
    }

    public Collection<RodBinding> getRodBindings() {
        return Collections.unmodifiableCollection(this.rodBindings);
    }

    private Collection<Object> findTargets(ArgumentSource source, Object instance) {
        LinkedHashSet<Object> targets = new LinkedHashSet<Object>();
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.equals(source.field)) {
                    targets.add(instance);
                    continue;
                }
                if (!field.isAnnotationPresent(ArgumentCollection.class)) continue;
                targets.addAll(this.findTargets(source, JVMUtils.getFieldValue(field, instance)));
            }
        }
        return targets;
    }

    public void printHelp(ApplicationDetails applicationDetails) {
        new HelpFormatter().printHelp(applicationDetails, this.argumentDefinitions);
    }

    public List<ArgumentSource> extractArgumentSources(Class sourceClass) {
        return this.extractArgumentSources(sourceClass, new Field[0]);
    }

    public ArgumentTypeDescriptor selectBestTypeDescriptor(Class type) {
        return ArgumentTypeDescriptor.selectBest(this.argumentTypeDescriptors, type);
    }

    private List<ArgumentSource> extractArgumentSources(Class sourceClass, Field[] parentFields) {
        Map<ArgumentSource, Object> bindings = this.extractArgumentBindings(null, sourceClass, parentFields);
        return new ArrayList<ArgumentSource>(bindings.keySet());
    }

    public Map<ArgumentSource, Object> extractArgumentBindings(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Incoming object cannot be null");
        }
        return this.extractArgumentBindings(obj, obj.getClass(), new Field[0]);
    }

    private Map<ArgumentSource, Object> extractArgumentBindings(Object obj, Class sourceClass, Field[] parentFields) {
        LinkedHashMap<ArgumentSource, Object> bindings = new LinkedHashMap<ArgumentSource, Object>();
        while (sourceClass != null) {
            Field[] fields;
            for (Field field : fields = sourceClass.getDeclaredFields()) {
                Object val;
                if (ArgumentTypeDescriptor.isArgumentAnnotationPresent(field)) {
                    val = obj != null ? JVMUtils.getFieldValue(field, obj) : null;
                    bindings.put(new ArgumentSource(parentFields, field, this.selectBestTypeDescriptor(field.getType())), val);
                }
                if (!field.isAnnotationPresent(ArgumentCollection.class)) continue;
                val = obj != null ? JVMUtils.getFieldValue(field, obj) : null;
                Field[] newParentFields = Arrays.copyOf(parentFields, parentFields.length + 1);
                newParentFields[parentFields.length] = field;
                bindings.putAll(this.extractArgumentBindings(val, field.getType(), newParentFields));
            }
            sourceClass = sourceClass.getSuperclass();
        }
        return bindings;
    }

    private boolean isArgumentForm(String token) {
        for (ParsingMethod parsingMethod : this.parsingMethods) {
            if (!parsingMethod.matches(token)) continue;
            return true;
        }
        return false;
    }

    private ArgumentMatch parseArgument(String token, ArgumentMatchSite position) {
        if (!this.isArgumentForm(token)) {
            throw new IllegalArgumentException("Token is not recognizable as an argument: " + token);
        }
        for (ParsingMethod parsingMethod : this.parsingMethods) {
            if (!parsingMethod.matches(token)) continue;
            return parsingMethod.match(this.argumentDefinitions, token, position);
        }
        return null;
    }

    public static enum ValidationType {
        MissingRequiredArgument,
        InvalidArgument,
        InvalidArgumentValue,
        ValueMissingArgument,
        TooManyValuesForArgument,
        MutuallyExclusive,
        OtherArgumentRequired;

    }
}

