/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatches;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.Multiplex;
import org.broadinstitute.gatk.utils.commandline.Multiplexer;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

class MultiplexArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    private final Multiplexer multiplexer;
    private final Collection<?> multiplexedIds;

    public MultiplexArgumentTypeDescriptor() {
        this.multiplexer = null;
        this.multiplexedIds = null;
    }

    private MultiplexArgumentTypeDescriptor(Multiplexer multiplexer, Collection<?> multiplexedIds) {
        this.multiplexer = multiplexer;
        this.multiplexedIds = multiplexedIds;
    }

    @Override
    public boolean supports(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return true;
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        if (this.multiplexer == null || this.multiplexedIds == null) {
            throw new ReviewedGATKException("No multiplexed ids available");
        }
        HashMap multiplexedMapping = new HashMap();
        Class componentType = MultiplexArgumentTypeDescriptor.makeRawTypeIfNecessary(this.getCollectionComponentType(source.field));
        ArgumentTypeDescriptor componentTypeDescriptor = parsingEngine.selectBestTypeDescriptor(componentType);
        for (Object id : this.multiplexedIds) {
            Object value = null;
            if (componentTypeDescriptor.createsTypeDefault(source)) {
                value = componentTypeDescriptor.createTypeDefault(parsingEngine, source, componentType);
            }
            multiplexedMapping.put(id, value);
        }
        return multiplexedMapping;
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "None";
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        if (this.multiplexedIds == null) {
            throw new ReviewedGATKException("Cannot directly parse a MultiplexArgumentTypeDescriptor; must create a derivative type descriptor first.");
        }
        HashMap multiplexedMapping = new HashMap();
        Class componentType = MultiplexArgumentTypeDescriptor.makeRawTypeIfNecessary(this.getCollectionComponentType(source.field));
        for (Object id : this.multiplexedIds) {
            Object value = parsingEngine.selectBestTypeDescriptor(componentType).parse(parsingEngine, source, componentType, matches.transform(this.multiplexer, id));
            multiplexedMapping.put(id, value);
        }
        parsingEngine.addTags(multiplexedMapping, this.getArgumentTags(matches));
        return multiplexedMapping;
    }

    public MultiplexArgumentTypeDescriptor createCustomTypeDescriptor(ParsingEngine parsingEngine, ArgumentSource dependentArgument, Object containingObject) {
        Multiplexer multiplexer;
        Constructor<? extends Multiplexer> multiplexerConstructor;
        Object[] sourceFields = dependentArgument.field.getAnnotation(Multiplex.class).arguments();
        List<ArgumentSource> allSources = parsingEngine.extractArgumentSources(containingObject.getClass());
        Class[] sourceTypes = new Class[sourceFields.length];
        Object[] sourceValues = new Object[sourceFields.length];
        int currentField = 0;
        for (String string : sourceFields) {
            boolean fieldFound = false;
            for (ArgumentSource source : allSources) {
                if (!source.field.getName().equals(string)) continue;
                if (source.field.isAnnotationPresent(Multiplex.class)) {
                    throw new ReviewedGATKException("Command-line arguments can only depend on independent fields");
                }
                sourceTypes[currentField] = source.field.getType();
                sourceValues[currentField] = JVMUtils.getFieldValue(source.field, containingObject);
                ++currentField;
                fieldFound = true;
            }
            if (fieldFound) continue;
            throw new ReviewedGATKException(String.format("Unable to find source field %s, referred to by dependent field %s", string, dependentArgument.field.getName()));
        }
        Class<? extends Multiplexer> multiplexerType = dependentArgument.field.getAnnotation(Multiplex.class).value();
        try {
            multiplexerConstructor = multiplexerType.getConstructor(sourceTypes);
            multiplexerConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new ReviewedGATKException(String.format("Unable to find constructor for class %s with parameters %s", multiplexerType.getName(), Arrays.deepToString(sourceFields)), ex);
        }
        try {
            multiplexer = multiplexerConstructor.newInstance(sourceValues);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReviewedGATKException(String.format("Constructor for class %s with parameters %s is inaccessible", multiplexerType.getName(), Arrays.deepToString(sourceFields)), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ReviewedGATKException(String.format("Can't create class %s with parameters %s", multiplexerType.getName(), Arrays.deepToString(sourceFields)), instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReviewedGATKException(String.format("Can't invoke constructor of class %s with parameters %s", multiplexerType.getName(), Arrays.deepToString(sourceFields)), invocationTargetException);
        }
        return new MultiplexArgumentTypeDescriptor(multiplexer, multiplexer.multiplex());
    }

    @Override
    protected Type getCollectionComponentType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            if (parameterizedType.getActualTypeArguments().length != 2) {
                throw new IllegalArgumentException("Unable to determine collection type of field: " + field.toString());
            }
            return (Class)parameterizedType.getActualTypeArguments()[1];
        }
        return String.class;
    }
}

