/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class ListAppender
extends AppenderSkeleton {
    protected final List<LoggingEvent> loggingEvents = new ArrayList<LoggingEvent>();
    protected int loggingEventsToKeep = 0;
    protected int numLoggingEvents = 0;
    protected Level logLevelToKeep = Level.WARN;

    public ListAppender(Layout layout, int loggingEventsToKeep, Level logLevelToKeep) {
        this.layout = layout;
        this.loggingEventsToKeep = loggingEventsToKeep;
        this.logLevelToKeep = logLevelToKeep;
    }

    private ListAppender() {
    }

    @Override
    public synchronized void close() {
        this.loggingEvents.clear();
        this.numLoggingEvents = 0;
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    @Override
    protected synchronized void append(LoggingEvent loggingEvent) {
        if (loggingEvent.getLevel().equals(this.logLevelToKeep)) {
            ++this.numLoggingEvents;
            if (this.numLoggingEvents <= this.loggingEventsToKeep) {
                this.loggingEvents.add(loggingEvent);
            }
        }
    }

    public synchronized String toString() {
        String msgType = this.logLevelToKeep.toString() + " messages";
        if (this.loggingEvents.isEmpty()) {
            return "There were no " + new String(msgType).toLowerCase() + ".\n";
        }
        String out = "There were " + Integer.toString(this.numLoggingEvents) + " " + msgType;
        if (this.layout == null) {
            throw new ReviewedGATKException("layout cannot be null");
        }
        out = out + ", the first " + this.loggingEvents.size() + " are repeated below.\n";
        for (LoggingEvent event : this.loggingEvents) {
            out = out + this.layout.format(event);
        }
        return out;
    }

    public void write() {
        System.out.print(this);
    }
}

