/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import htsjdk.samtools.util.Log;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.ArgumentException;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.CommandLineUtils;
import org.broadinstitute.gatk.utils.commandline.ListAppender;
import org.broadinstitute.gatk.utils.commandline.Output;
import org.broadinstitute.gatk.utils.commandline.ParsedArgs;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.help.ApplicationDetails;
import org.broadinstitute.gatk.utils.help.HelpFormatter;
import org.broadinstitute.gatk.utils.text.TextFormattingUtils;

public abstract class CommandLineProgram {
    private static final int NUM_WARN_MESSAGES = 10;
    public ParsingEngine parser = null;
    @Argument(fullName="logging_level", shortName="l", doc="Set the minimum level of logging", required=false)
    protected String logging_level = "INFO";
    @Output(fullName="log_to_file", shortName="log", doc="Set the logging location", required=false)
    protected String toFile = null;
    @Argument(fullName="help", shortName="h", doc="Generate the help message", required=false)
    public Boolean help = false;
    @Argument(fullName="version", shortName="version", doc="Output version information", required=false)
    public Boolean version = false;
    private static final String patternString = "%-5p %d{HH:mm:ss,SSS} %C{1} - %m %n";
    public static int result;

    protected ApplicationDetails getApplicationDetails() {
        return new ApplicationDetails(ApplicationDetails.createDefaultHeader(this.getClass()), Collections.emptyList(), ApplicationDetails.createDefaultRunningInstructions(this.getClass()), null);
    }

    protected Collection<ArgumentTypeDescriptor> getArgumentTypeDescriptors() {
        return Collections.emptyList();
    }

    protected boolean canAddArgumentsDynamically() {
        return false;
    }

    protected Class[] getArgumentSources() {
        return new Class[0];
    }

    protected String getArgumentSourceName(Class source) {
        return source.toString();
    }

    public void setParser(ParsingEngine parser) {
        this.parser = parser;
    }

    protected abstract int execute() throws Exception;

    public static void start(CommandLineProgram clp, String[] args) throws Exception {
        CommandLineProgram.start(clp, args, false);
    }

    public static void start(CommandLineProgram clp, String[] args, boolean dryRun) throws Exception {
        block14: {
            SortedMap<ArgumentMatchSource, ParsedArgs> parsedArgs;
            PatternLayout layout = new PatternLayout(patternString);
            Logger logger = CommandLineUtils.getStingLogger();
            ListAppender listAppender = new ListAppender(layout, 10, Level.WARN);
            logger.addAppender(listAppender);
            CommandLineUtils.setLayout(logger, layout);
            clp.setupLoggerLevel();
            ParsingEngine parser = clp.parser = new ParsingEngine(clp);
            parser.addArgumentSource(clp.getClass());
            if (clp.canAddArgumentsDynamically()) {
                Class[] argumentSources;
                parser.parse(args);
                if (!dryRun) {
                    parser.validate(EnumSet.of(ParsingEngine.ValidationType.MissingRequiredArgument, ParsingEngine.ValidationType.InvalidArgument));
                }
                parser.loadArgumentsIntoObject(clp);
                clp.setupLoggerLevel();
                for (Class argumentSource : argumentSources = clp.getArgumentSources()) {
                    parser.addArgumentSource(clp.getArgumentSourceName(argumentSource), argumentSource);
                }
                parsedArgs = parser.parse(args);
                if (CommandLineProgram.isVersionPresent(parser)) {
                    CommandLineProgram.printVersionAndExit();
                }
                if (CommandLineProgram.isHelpPresent(parser)) {
                    CommandLineProgram.printHelpAndExit(clp, parser);
                }
                if (!dryRun) {
                    parser.validate();
                }
            } else {
                parsedArgs = parser.parse(args);
                if (!dryRun) {
                    if (CommandLineProgram.isHelpPresent(parser)) {
                        CommandLineProgram.printHelpAndExit(clp, parser);
                    }
                    parser.validate();
                }
                parser.loadArgumentsIntoObject(clp);
                clp.setupLoggerLevel();
            }
            if (dryRun) break block14;
            if (clp.toFile != null) {
                try {
                    FileAppender appender = new FileAppender(layout, clp.toFile, false);
                    logger.addAppender(appender);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to re-route log output to " + clp.toFile + " make sure the destination exists");
                }
            }
            HelpFormatter.generateHeaderInformation(clp.getApplicationDetails(), parsedArgs);
            result = clp.execute();
            CommandLineProgram.printDoneAndLogMessages(listAppender);
            listAppender.close();
        }
    }

    public void loadArgumentsIntoObject(Object obj) {
        this.parser.loadArgumentsIntoObject(obj);
    }

    private void setupLoggerLevel() {
        Log.LogLevel htsjdkLevel;
        Level gatkLevel;
        if (this.logging_level.toUpperCase().equals("DEBUG")) {
            gatkLevel = Level.DEBUG;
            htsjdkLevel = Log.LogLevel.DEBUG;
        } else if (this.logging_level.toUpperCase().equals("INFO")) {
            gatkLevel = Level.INFO;
            htsjdkLevel = Log.LogLevel.INFO;
        } else if (this.logging_level.toUpperCase().equals("WARN")) {
            gatkLevel = Level.WARN;
            htsjdkLevel = Log.LogLevel.WARNING;
        } else if (this.logging_level.toUpperCase().equals("ERROR")) {
            gatkLevel = Level.ERROR;
            htsjdkLevel = Log.LogLevel.ERROR;
        } else if (this.logging_level.toUpperCase().equals("FATAL")) {
            gatkLevel = Level.FATAL;
            htsjdkLevel = Log.LogLevel.ERROR;
        } else if (this.logging_level.toUpperCase().equals("OFF")) {
            gatkLevel = Level.OFF;
            htsjdkLevel = Log.LogLevel.ERROR;
        } else {
            throw new ArgumentException("Unable to match: " + this.logging_level + " to a logging level, make sure it's a valid level (DEBUG, INFO, WARN, ERROR, FATAL, OFF)");
        }
        Logger.getRootLogger().setLevel(gatkLevel);
        Log.setGlobalLogLevel(htsjdkLevel);
    }

    public static String getVersionNumber() {
        ResourceBundle headerInfo = TextFormattingUtils.GATK_RESOURCE_BUNDLE;
        return headerInfo.containsKey("org.broadinstitute.gatk.utils.version") ? headerInfo.getString("org.broadinstitute.gatk.utils.version") : "<unknown>";
    }

    public static String getBuildTime() {
        ResourceBundle headerInfo = TextFormattingUtils.GATK_RESOURCE_BUNDLE;
        return headerInfo.containsKey("build.timestamp") ? headerInfo.getString("build.timestamp") : "<unknown>";
    }

    private static void printDocumentationReference() {
        CommandLineProgram.errorPrintf("Visit our website and forum for extensive documentation and answers to %n", new Object[0]);
        CommandLineProgram.errorPrintf("commonly asked questions https://software.broadinstitute.org/gatk%n", new Object[0]);
    }

    private static boolean isHelpPresent(ParsingEngine parser) {
        return parser.isArgumentPresent("help");
    }

    private static void printHelpAndExit(CommandLineProgram clp, ParsingEngine parser) {
        parser.printHelp(clp.getApplicationDetails());
        System.exit(0);
    }

    private static boolean isVersionPresent(ParsingEngine parser) {
        return parser.isArgumentPresent("version");
    }

    private static void printDoneAndLogMessages(ListAppender listAppender) {
        System.err.println("------------------------------------------------------------------------------------------");
        System.err.print("Done. ");
        listAppender.write();
        System.err.println("------------------------------------------------------------------------------------------");
    }

    private static void printVersionAndExit() {
        System.out.println(CommandLineProgram.getVersionNumber().toString());
        System.exit(0);
    }

    private static void errorPrintf(String format, Object ... s) {
        String formatted = String.format(format, s);
        if (formatted.trim().equals("")) {
            System.err.println("##### ERROR");
        } else {
            for (String part : formatted.split("\n")) {
                System.err.println("##### ERROR " + part);
            }
        }
    }

    public static void exitSystemWithError(String msg, Throwable t) {
        CommandLineProgram.errorPrintf("--%n", new Object[0]);
        CommandLineProgram.errorPrintf("stack trace %n", new Object[0]);
        t.printStackTrace();
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("A GATK RUNTIME ERROR has occurred (version %s):%n", CommandLineProgram.getVersionNumber());
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("This might be a bug. Please check the documentation guide to see if this is a known problem.%n", new Object[0]);
        CommandLineProgram.errorPrintf("If not, please post the error message, with stack trace, to the GATK forum.%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        if (msg == null) {
            msg = "Code exception (see stack trace for error itself)";
        }
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", msg.trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithUserError(Exception e) {
        if (e.getMessage() == null) {
            throw new ReviewedGATKException("UserException found with no message!", e);
        }
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("A USER ERROR has occurred (version %s): %n", CommandLineProgram.getVersionNumber());
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("This means that one or more arguments or inputs in your command are incorrect.%n", new Object[0]);
        CommandLineProgram.errorPrintf("The error message below tells you what is the problem.%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("If the problem is an invalid argument, please check the online documentation guide%n", new Object[0]);
        CommandLineProgram.errorPrintf("(or rerun your command with --help) to view allowable command-line arguments for this tool.%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please do NOT post this error to the GATK forum unless you have really tried to fix it yourself.%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", e.getMessage().trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithSamError(Throwable t) {
        if (t.getMessage() == null) {
            throw new ReviewedGATKException("SamException found with no message!", t);
        }
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        CommandLineProgram.errorPrintf("AN INPUT FILE ERROR has occurred (version %s): %n", CommandLineProgram.getVersionNumber());
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("This means that there is something wrong with the input file(s) you provided.%n", new Object[0]);
        CommandLineProgram.errorPrintf("The error message below tells you what is the problem.%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.printDocumentationReference();
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("Please do NOT post this error to the GATK forum until you have followed these instructions:%n", new Object[0]);
        CommandLineProgram.errorPrintf("- Make sure that your BAM file is well-formed by running Picard's validator on it%n", new Object[0]);
        CommandLineProgram.errorPrintf("(see http://picard.sourceforge.net/command-line-overview.shtml#ValidateSamFile for details)%n", new Object[0]);
        CommandLineProgram.errorPrintf("- Ensure that your BAM index is not corrupted: delete the current one and regenerate it with 'samtools index'%n", new Object[0]);
        CommandLineProgram.errorPrintf("- Ensure that your CRAM index is not corrupted: delete the current one and regenerate it with%n", new Object[0]);
        CommandLineProgram.errorPrintf("'java -jar cramtools-3.0.jar index --bam-style-index --input-file <input cram file> --reference-fasta-file <reference fasta file>'%n", new Object[0]);
        CommandLineProgram.errorPrintf("(see https://github.com/enasequence/cramtools/tree/v3.0 for details)%n", new Object[0]);
        CommandLineProgram.errorPrintf("%n", new Object[0]);
        CommandLineProgram.errorPrintf("MESSAGE: %s%n", t.getMessage().trim());
        CommandLineProgram.errorPrintf("------------------------------------------------------------------------------------------%n", new Object[0]);
        System.exit(1);
    }

    public static void exitSystemWithError(Throwable t) {
        CommandLineProgram.exitSystemWithError(t.getMessage(), t);
    }

    protected static void forceJVMLocaleToUSEnglish() {
        Locale.setDefault(Locale.US);
    }

    static {
        CommandLineProgram.forceJVMLocaleToUSEnglish();
        CommandLineUtils.configureConsoleLogging();
        result = -1;
    }
}

