/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentIOType;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatch;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchStringValue;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchValue;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatches;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.Hidden;
import org.broadinstitute.gatk.utils.commandline.Input;
import org.broadinstitute.gatk.utils.commandline.Output;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.commandline.ParsingMethod;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.commandline.RodBindingCollection;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.refdata.tracks.FeatureManager;
import org.broadinstitute.gatk.utils.text.XReadLines;

public abstract class ArgumentTypeDescriptor {
    private static Class[] ARGUMENT_ANNOTATIONS = new Class[]{Input.class, Output.class, Argument.class};
    protected static final Logger logger = Logger.getLogger(ArgumentTypeDescriptor.class);

    public static ArgumentTypeDescriptor selectBest(Collection<ArgumentTypeDescriptor> descriptors, Class type) {
        for (ArgumentTypeDescriptor descriptor : descriptors) {
            if (!descriptor.supports(type)) continue;
            return descriptor;
        }
        throw new ReviewedGATKException("Can't process command-line arguments of type: " + type.getName());
    }

    public static boolean isCompressed(String writerFileName) {
        return writerFileName != null && AbstractFeatureReader.hasBlockCompressedExtension(writerFileName);
    }

    public abstract boolean supports(Class var1);

    public boolean createsTypeDefault(ArgumentSource source) {
        return false;
    }

    public String typeDefaultDocString(ArgumentSource source) {
        throw new UnsupportedOperationException();
    }

    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        throw new UnsupportedOperationException("Unable to create default for type " + this.getClass());
    }

    public List<ArgumentDefinition> createArgumentDefinitions(ArgumentSource source) {
        return Collections.singletonList(this.createDefaultArgumentDefinition(source));
    }

    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, ArgumentMatches matches) {
        return this.parse(parsingEngine, source, source.field.getGenericType(), matches);
    }

    public boolean isMultiValued(ArgumentSource source) {
        Class<?> argumentType = source.field.getType();
        return Collection.class.isAssignableFrom(argumentType) || argumentType.isArray();
    }

    protected ArgumentDefinition createDefaultArgumentDefinition(ArgumentSource source) {
        Annotation argumentAnnotation = ArgumentTypeDescriptor.getArgumentAnnotation(source);
        return new ArgumentDefinition(ArgumentIOType.getIOType(argumentAnnotation), source.field.getType(), ArgumentDefinition.getFullName(argumentAnnotation, source.field.getName()), ArgumentDefinition.getShortName(argumentAnnotation), ArgumentDefinition.getDoc(argumentAnnotation), source.isRequired() && !this.createsTypeDefault(source) && !source.isFlag() && !source.isDeprecated(), source.isFlag(), source.isMultiValued(), source.isHidden(), ArgumentTypeDescriptor.makeRawTypeIfNecessary(this.getCollectionComponentType(source.field)), ArgumentDefinition.getExclusiveOf(argumentAnnotation), ArgumentDefinition.getOtherArgumentRequired(argumentAnnotation), ArgumentDefinition.getValidationRegex(argumentAnnotation), this.getValidOptions(source));
    }

    protected Type getCollectionComponentType(Field field) {
        return null;
    }

    public abstract Object parse(ParsingEngine var1, ArgumentSource var2, Type var3, ArgumentMatches var4);

    protected List<String> getValidOptions(ArgumentSource source) {
        if (!source.field.getType().isEnum()) {
            return null;
        }
        ArrayList<String> validOptions = new ArrayList<String>();
        for (Object constant : source.field.getType().getEnumConstants()) {
            validOptions.add(constant.toString());
        }
        return validOptions;
    }

    protected boolean argumentIsPresent(ArgumentDefinition definition, ArgumentMatches matches) {
        for (ArgumentMatch match : matches) {
            if (!match.definition.equals(definition)) continue;
            return true;
        }
        return false;
    }

    protected ArgumentMatchValue getArgumentValue(ArgumentDefinition definition, ArgumentMatches matches) {
        Collection<ArgumentMatchValue> argumentValues = this.getArgumentValues(definition, matches);
        if (argumentValues.size() > 1) {
            throw new UserException.CommandLineException("Multiple values associated with given definition, but this argument expects only one: " + definition.fullName);
        }
        return argumentValues.size() > 0 ? argumentValues.iterator().next() : null;
    }

    protected Tags getArgumentTags(ArgumentMatches matches) {
        Tags tags = new Tags();
        for (ArgumentMatch match : matches) {
            if (!tags.isEmpty() && !match.tags.isEmpty()) {
                throw new ReviewedGATKException("BUG: multiple conflicting sets of tags are available, and the type descriptor specifies no way of resolving the conflict.");
            }
            tags = match.tags;
        }
        return tags;
    }

    protected Collection<ArgumentMatchValue> getArgumentValues(ArgumentDefinition definition, ArgumentMatches matches) {
        ArrayList<ArgumentMatchValue> values = new ArrayList<ArgumentMatchValue>();
        for (ArgumentMatch match : matches) {
            if (!match.definition.equals(definition)) continue;
            values.addAll(match.values());
        }
        return values;
    }

    protected static Annotation getArgumentAnnotation(ArgumentSource source) {
        for (Class annotation : ARGUMENT_ANNOTATIONS) {
            if (!source.field.isAnnotationPresent(annotation)) continue;
            return source.field.getAnnotation(annotation);
        }
        throw new ReviewedGATKException("ArgumentAnnotation is not present for the argument field: " + source.field.getName());
    }

    public static boolean isArgumentAnnotationPresent(Field field) {
        for (Class annotation : ARGUMENT_ANNOTATIONS) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArgumentHidden(Field field) {
        return field.isAnnotationPresent(Hidden.class);
    }

    public static Class makeRawTypeIfNecessary(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        throw new IllegalArgumentException("Unable to determine Class-derived component type of field: " + t);
    }

    protected Object parseBinding(ArgumentSource source, Type type, ArgumentMatches matches, Tags tags) {
        ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
        ArgumentMatchValue value = this.getArgumentValue(defaultDefinition, matches);
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        String name = defaultDefinition.fullName;
        return ArgumentTypeDescriptor.parseBinding(value, parameterType, type, name, tags, source.field.getName());
    }

    public static Object parseBinding(ArgumentMatchValue value, Class<? extends Feature> parameterType, Type bindingClass, String bindingName, Tags tags, String fieldName) {
        try {
            FeatureManager manager;
            String tribbleType = null;
            if (tags.getPositionalTags().size() > 2) {
                throw new UserException.CommandLineException(String.format("Unexpected number of positional tags for argument %s : %s. Rod bindings only support -X:type and -X:name,type argument styles", value.asString(), fieldName));
            }
            if (tags.getPositionalTags().size() == 2) {
                bindingName = tags.getPositionalTags().get(0);
                manager = new FeatureManager();
                tribbleType = tags.getPositionalTags().get(1);
                if (manager.getByName(tribbleType) == null) {
                    throw new UserException.UnknownTribbleType(tribbleType, String.format("Unable to find tribble type '%s' provided on the command line. Please select a correct type from among the supported types:%n%s", tribbleType, manager.userFriendlyListOfAvailableFeatures(parameterType)));
                }
            } else {
                String tag1;
                manager = new FeatureManager();
                String string = tag1 = tags.getPositionalTags().size() == 1 ? tags.getPositionalTags().get(0) : null;
                if (tag1 != null) {
                    if (manager.getByName(tag1) != null) {
                        tribbleType = tag1;
                    } else {
                        bindingName = tag1;
                    }
                }
                if (tribbleType == null) {
                    FeatureManager.FeatureDescriptor featureDescriptor;
                    File file = value.asFile();
                    if (file.canRead() && file.isFile() && (featureDescriptor = manager.getByFiletype(file)) != null) {
                        tribbleType = featureDescriptor.getName();
                        logger.debug("Dynamically determined type of " + file + " to be " + tribbleType);
                    }
                    if (tribbleType == null) {
                        Class rawType = ArgumentTypeDescriptor.makeRawTypeIfNecessary(bindingClass);
                        try {
                            return rawType.getConstructor(String.class).newInstance(value.asString());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (!file.exists()) {
                                throw new UserException.CouldNotReadInputFile(file, "file '" + file + "' does not exist");
                            }
                            if (!file.canRead() || !file.isFile()) {
                                throw new UserException.CouldNotReadInputFile(file, "file '" + file + "' could not be read");
                            }
                            throw new UserException.CommandLineException(String.format("No tribble type was provided on the command line and the type of the file '" + file + "' could not be determined dynamically. " + "Please add an explicit type tag :NAME listing the correct type from among the supported types:%n%s", manager.userFriendlyListOfAvailableFeatures(parameterType)));
                        }
                    }
                }
            }
            Constructor ctor = ArgumentTypeDescriptor.makeRawTypeIfNecessary(bindingClass).getConstructor(Class.class, String.class, String.class, String.class, Tags.class);
            return ctor.newInstance(parameterType, bindingName, value.asString(), tribbleType, tags);
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                throw (UserException)e;
            }
            throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s. Message: %s", value, fieldName, e.getMessage()));
        }
    }

    public Object parseRodBindingCollectionSource(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches, Tags tags) {
        ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
        ArgumentMatchValue value = this.getArgumentValue(defaultDefinition, matches);
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        String name = defaultDefinition.fullName;
        File file = value.asFile();
        try {
            if (file.getAbsolutePath().endsWith(".list")) {
                return ArgumentTypeDescriptor.getRodBindingsCollection(file, parsingEngine, parameterType, name, tags, source.field.getName());
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(file, (Exception)e);
        }
        RodBinding binding = (RodBinding)ArgumentTypeDescriptor.parseBinding(value, parameterType, RodBinding.class, name, tags, source.field.getName());
        parsingEngine.addTags(binding, tags);
        parsingEngine.addRodBinding(binding);
        return RodBindingCollection.createRodBindingCollectionOfType(parameterType, Arrays.asList(binding));
    }

    public static Object getRodBindingsCollection(File file, ParsingEngine parsingEngine, Class<? extends Feature> parameterType, String bindingName, Tags defaultTags, String fieldName) throws IOException {
        ArrayList<RodBinding> bindings = new ArrayList<RodBinding>();
        HashSet<String> fileValues = new HashSet<String>();
        for (String line : new XReadLines(file)) {
            RodBinding binding;
            String[] tokens = line.split("\\s+");
            if (tokens.length == 0) continue;
            if (tokens.length == 1) {
                ArgumentMatchValue value = ArgumentTypeDescriptor.parseAndValidateArgumentMatchValue(tokens[0], fileValues, fieldName, file.getName());
                binding = (RodBinding)ArgumentTypeDescriptor.parseBinding(value, parameterType, RodBinding.class, bindingName, defaultTags, fieldName);
                parsingEngine.addTags(binding, defaultTags);
            } else if (tokens.length == 2) {
                Tags tags = ParsingMethod.parseTags(fieldName, tokens[0]);
                ArgumentMatchValue value = ArgumentTypeDescriptor.parseAndValidateArgumentMatchValue(tokens[1], fileValues, fieldName, file.getName());
                binding = (RodBinding)ArgumentTypeDescriptor.parseBinding(value, parameterType, RodBinding.class, bindingName, tags, fieldName);
                parsingEngine.addTags(binding, tags);
            } else {
                throw new UserException.BadArgumentValue(fieldName, "data lines should consist of an optional set of tags along with a path to a file; too many tokens are present for line: " + line);
            }
            bindings.add(binding);
            parsingEngine.addRodBinding(binding);
        }
        if (fileValues.isEmpty()) {
            throw new UserException.BadArgumentValue(fieldName, "The input list " + file.getName() + " is empty.");
        }
        return RodBindingCollection.createRodBindingCollectionOfType(parameterType, bindings);
    }

    private static ArgumentMatchValue parseAndValidateArgumentMatchValue(String token, Set<String> fileValues, String fieldName, String listFileName) {
        ArgumentTypeDescriptor.checkForDuplicateFileName(token, fileValues, fieldName, listFileName);
        return new ArgumentMatchStringValue(token);
    }

    protected static void checkForDuplicateFileName(String currentFile, Set<String> processedFiles, String fieldName, String listName) {
        if (processedFiles.contains(currentFile)) {
            throw new UserException.BadArgumentValue(fieldName, "The input list " + listName + " contains file " + currentFile + " multiple times, which isn't allowed. If you are intentionally trying to " + "include the same file more than once, you will need to specify it in separate file lists.");
        }
        processedFiles.add(currentFile);
    }
}

