/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinitionGroup;
import org.broadinstitute.gatk.utils.commandline.DefinitionMatcher;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class ArgumentDefinitions
implements Iterable<ArgumentDefinition> {
    private Set<ArgumentDefinition> argumentDefinitions = new HashSet<ArgumentDefinition>();
    private Set<ArgumentDefinitionGroup> argumentDefinitionGroups = new HashSet<ArgumentDefinitionGroup>();
    static DefinitionMatcher FullNameDefinitionMatcher = new DefinitionMatcher(){

        @Override
        public boolean matches(ArgumentDefinition definition, Object key) {
            if (definition.fullName == null) {
                return key == null;
            }
            return definition.fullName.equals(key);
        }
    };
    static DefinitionMatcher ShortNameDefinitionMatcher = new DefinitionMatcher(){

        @Override
        public boolean matches(ArgumentDefinition definition, Object key) {
            if (definition.shortName == null) {
                return key == null;
            }
            return definition.shortName.equals(key);
        }
    };
    static DefinitionMatcher RequiredDefinitionMatcher = new DefinitionMatcher(){

        @Override
        public boolean matches(ArgumentDefinition definition, Object key) {
            if (!(key instanceof Boolean)) {
                throw new IllegalArgumentException("RequiredDefinitionMatcher requires boolean key");
            }
            return definition.required == (Boolean)key;
        }
    };
    static DefinitionMatcher VerifiableDefinitionMatcher = new DefinitionMatcher(){

        @Override
        public boolean matches(ArgumentDefinition definition, Object key) {
            return !definition.isFlag && !definition.argumentType.isEnum();
        }
    };

    public void add(ArgumentDefinitionGroup argumentDefinitionGroup) {
        for (ArgumentDefinition definition : argumentDefinitionGroup) {
            if (definition.fullName.length() == 0) {
                throw new IllegalArgumentException("Argument cannot have 0-length fullname.");
            }
            if (this.hasArgumentDefinition(definition.fullName, FullNameDefinitionMatcher)) {
                throw new ReviewedGATKException("Duplicate definition of argument with full name: " + definition.fullName);
            }
            if (definition.shortName != null && this.hasArgumentDefinition(definition.shortName, ShortNameDefinitionMatcher)) {
                throw new ReviewedGATKException("Duplicate definition of argument with short name: " + definition.shortName);
            }
            this.argumentDefinitions.add(definition);
        }
        Iterator<ArgumentDefinitionGroup> definitionGroupIterator = this.argumentDefinitionGroups.iterator();
        while (definitionGroupIterator.hasNext()) {
            ArgumentDefinitionGroup candidate = definitionGroupIterator.next();
            if (!candidate.groupNameMatches(argumentDefinitionGroup)) continue;
            argumentDefinitionGroup = candidate.merge(argumentDefinitionGroup);
            definitionGroupIterator.remove();
        }
        this.argumentDefinitionGroups.add(argumentDefinitionGroup);
    }

    public boolean hasArgumentDefinition(Object property, DefinitionMatcher matcher) {
        return this.findArgumentDefinitions(property, matcher).size() > 0;
    }

    public ArgumentDefinition findArgumentDefinition(Object property, DefinitionMatcher matcher) {
        Collection<ArgumentDefinition> selectedDefinitions = this.findArgumentDefinitions(property, matcher);
        if (selectedDefinitions.size() > 1) {
            throw new IllegalArgumentException("Multiple argument definitions match the selected property: " + property);
        }
        if (selectedDefinitions.size() == 0) {
            return null;
        }
        return selectedDefinitions.iterator().next();
    }

    public Collection<ArgumentDefinition> findArgumentDefinitions(Object property, DefinitionMatcher matcher) {
        HashSet<ArgumentDefinition> selectedArgumentDefinitions = new HashSet<ArgumentDefinition>();
        for (ArgumentDefinition argumentDefinition : this.argumentDefinitions) {
            if (!matcher.matches(argumentDefinition, property)) continue;
            selectedArgumentDefinitions.add(argumentDefinition);
        }
        return selectedArgumentDefinitions;
    }

    public Collection<ArgumentDefinitionGroup> getArgumentDefinitionGroups() {
        return this.argumentDefinitionGroups;
    }

    @Override
    public Iterator<ArgumentDefinition> iterator() {
        return this.argumentDefinitions.iterator();
    }
}

